;; -*- Lisp -*- 

;;;; JTRE definitions  
;;;; Version 7, Last edited 3/19/1991

;;; Copyright (c) 1989, 1990, 1991 Kenneth D. Forbus, Northwestern University,
;;; Johan de Kleer and Xerox Corporation.
;;; All rights reserved.

(defstruct (jtre :conc-name
		 (:print-function jtre-printer))
  title                   ; Pretty name
  jtms                    ; Pointer to its JTMS
  (class-table nil)       ; Table of classes
  (datum-counter 0)       ; Unique ID for asserts
  (rule-counter 0)        ; Unique ID for rules
  (debugging nil)         ; If non-NIL, show basic operations
  (queue nil)             ; Rule queue
  (rules-run 0))          ; Statistic

(defun jtre-printer (j st ignore)
  (declare (ignore ignore))
  (format st "<JTRE: ~A>" (jtre-title j)))

(defvar *JTRE* nil)
;;; The binding of this symbol is used inside rules and various
;;; macros to specify which JTRE a rule or fact should be stored in.
;;; The next few procedures encapsulate this choice		

(defmacro with-JTRE (jtre &rest forms)
  `(let ((*JTRE* ,jtre)) ,@ forms))

(defun in-JTRE (jtre) (setq *JTRE* jtre))

(defmacro debugging-jtre (msg &rest args)
  `(when (jtre-debugging *JTRE*) (format t ,msg  ,@args)))

;;; Setting up JTRE

(defun create-jtre (title &key debugging)
 (let ((j (make-jtre
	   :TITLE title 
	   :JTMS (create-jtms (list :JTMS-OF title) 
			      :node-printer 'view-node)
	   :CLASS-TABLE (make-hash-table :test #'eq)
	   :DEBUGGING debugging)))
   (change-jtms (jtre-jtms j)
		:enqueue-procedure
		#'(lambda (rule) (enqueue rule j)))
   j))

(defun change-jtre (jtre &key debugging)
  (if debugging (setf (jtre-debugging jtre) debugging)))

;;;; Running JTRE

(defun uassert! (fact &optional (just 'user))
  (assert! fact just) ;; Do internal operation
  (run-rules *JTRE*))        ;; Run the rules

(defun uassume! (fact reason) ;; Similar to UASSERT!
  (assume! fact reason *JTRE*)
  (run-rules *JTRE*))

(defun run-forms (forms &optional (*JTRE* *JTRE*))
  (dolist (form forms) (eval form) (run-rules *JTRE*)))

(defun run (&optional (*JTRE* *JTRE*)) ;; Toplevel driver function
    (format T "~%>>")
    (do ((form (read) (read)))
        ((member form '(quit stop exit abort)) nil)
        (format t "~%~A" (eval form))
        (run-rules)
        (format t "~%>>")))

(defun show (&optional (*JTRE* *JTRE*) (stream *standard-output*))
  (show-data *JTRE* stream) (show-rules *JTRE* stream))

