;; -*- Lisp -*-

;;;; Natural deduction examples for TRE-CON.

;; Copyright (c) 1988, 1989, Kenneth D. Forbus, University of Illinois
;; All rights reserved.

(defvar *nd-rules* 
  #+Lucid
  "/u/bps/code/jtms/jnd.lisp"
  #+GCLISP
  "c:\\GCLISP2\\BPS\\TRE\\FND.LSP")

(defvar *jtre* nil)

(defun restart ()
  (setq *jtre* (create-jtre "JTRE for ND" :debugging t :debugging-context t))
  (contradiction 'contradiction *jtre*) ;; Install a node for contradictions
  (load *nd-rules*))

(defun ex1 () ;tests NI, CE, OI, and contradiction detection.
  (restart)
  (time (run-forms '((assume! '(implies p q) 'ex1 *jtre*)
		     (assume! '(not q) 'ex1 *jtre*)
		     (assume! '(show (not p)) 'ex1 *jtre*))
		   *jtre*)))

(defun ex2 () ;tests CI and OE.
  (restart)
  (time (run-forms '((assume! '(or (not P) R) 'ex2 *jtre*)
		     (assume! '(implies R Q) 'ex2 *jtre*)
		     (assume! '(show (implies P Q)) 'Ex2 *jtre*))
		   *jtre*)))

(defun ex3 () ;tests AE and AI.
  (restart)
  (time (run-forms '((assume! '(and A B) 'ex3 *jtre*)
		     (assume! '(and B C) 'ex3 *jtre*)
		     (assume! '(show (and A B C)) 'ex3 *jtre*))
		   *jtre*)))

(defun ex4 () ;tests BI and "Star Trek" problem
  (restart)
  (time (run-forms '((assume! 'contradiction 'ex4 *jtre*)
		     (assume! '(show (iff P Q)) 'ex4 *jtre*))
		   *jtre*)))

(defun ex5 () ;tests indirect proof.
  (restart)
  (time (run-forms '((assume! '(implies (not p) q) 'ex5 *jtre*)
		     (assume! '(not q) 'ex5 *jtre*)
		     (assume! '(show p) 'ex5 *jtre*))
		   *jtre*)))

;;; Here are some examples from class

(defun ex6 ()
  (restart)
  (time (run-forms '((assume! '(iff (and R L (not P)) J) 'ex6 *jtre*)
		     (assume! '(implies (not A) (not R)) 'ex6 *jtre*)
		     (assume! '(not A) 'ex6 *jtre*)
		     (assume! '(show (not J)) 'ex6 *jtre*))
		   *jtre*)))

(defun ex7 ()
  (restart)
  (time (run-forms '((assume! '(implies (and J C) P) 'ex7 *jtre*)
		     (assume! '(iff (and M C) (or P J)) 'ex7 *jtre*)
		     (assume! 'J 'ex7 *jtre*)
		     (assume! '(show (and P M)) 'ex7 *jtre*))
		   *jtre*)))

(defun ex8 ()
  (restart)  ;; A tough one
  (time (run-forms '((assume! '(show (implies (implies p q)
					      (or (not p) q))) 'ex8 *jtre*))
		   *jtre*)))

(defun ex9 ()
  (restart)
  (time (run-forms '((assume! '(or (and F G) (and G B)) 'ex9 *jtre*)
		     (assume! '(implies F (not G)) 'ex9 *jtre*)
		     (assume! '(show B) 'ex9 *jtre*))
		   *jtre*)))
