;; -*- Lisp -*-

;;;; Operators for JSAINT

(in-package 'user)

(defIntegration Integral-of-Constant
  (Integral ?t ?var) 
  :test (not (occurs-in? ?var ?t))
  :result (* ?t ?var))

(defIntegration Integral-of-Self
  (Integral ?exp ?exp)
  :result (/ (expt ?exp 2) 2))

(defIntegration Move-Constant-outside
  (Integral (* ?const ?nonconst) ?var)
  :test (and (not (occurs-in? ?var ?const))
	     (occurs-in? ?var ?nonconst))
  :subproblems ((?int (Integrate (Integral ?nonconst ?var))))
  :result (* ?const ?int))

(defIntegration Integral-of-Sum
  (Integral (+ ?t1 ?t2) ?var)
  :subproblems ((?int1 (Integrate (Integral ?t1 ?var)))
		(?int2 (Integrate (Integral ?t2 ?var))))
  :result (+ ?int1 ?int2))

(defIntegration Integral-of-Nary-sum
  (Integral (+ ?t1 ?t2 . ?trest) ?var)
  :subproblems ((?int1 (Integrate (Integral ?t1 ?var)))
		(?int2 (Integrate (Integral ?t2 ?var)))
		(?intr (Integrate (Integral (+ . ?trest) ?var))))
  :test (not (null ?trest))
  :result (+ ?int1 ?int2 ?intr))

(defIntegration Integral-of-uminus
  (Integral (- ?term) ?var)
  :subproblems ((?int (Integrate (Integral ?term ?var))))
  :result (- ?int))

(defIntegration Integral-of-minus
  (Integral (- ?t1 ?t2) ?var)
  :subproblems ((?int1 (Integrate (Integral ?t1 ?var)))
		(?int2 (Integrate (Integral ?t2 ?var))))
  :result (- ?int1 ?int2))

(defIntegration Integral-of-SQR
  (Integral (sqr ?var) ?var)
  :result (/ (expt ?var 3) 3))

(defIntegration Integral-of-polyterm
  (Integral (expt ?var ?n) ?var)
  :test (not (same-constant? ?n -1))
  :result (/ (expt ?var (+ 1 ?n)) (+ 1 ?n)))

;;;; Some exponentials and trig functions

(defIntegration Simple-e-integral
  (Integral (expt %e ?var) ?var)
  :result (expt %e ?var))

(defIntegration e-integral
  (Integral (expt %e (* ?a ?var)) ?var)
  :test (not (occurs-in? ?var ?a))
  :result (/ (expt %e (* ?a ?var)) ?a))

(defIntegration non-e-power-integral
  (Integral (expt ?b (* ?a ?var)) ?var)
  :test (and (not (occurs-in? ?var ?a))
	     (not (occurs-in? ?var ?b)))
  :result (/ (expt ?b (* ?a ?var)) (* ?a (log ?b %e))))

(defIntegration Log-Integral
  (Integral (log ?var %e) ?var)
  :result (- (* ?var (log ?var %e)) ?var))

(defIntegration sin-integral
  (Integral (sin (* ?a ?var)) ?var)
  :test (not (occurs-in? ?var ?a))
  :result (- (/ (cos (* ?a ?var)) ?a)))

;;;; Rational functions

;; Two pattern-matching foibles below: 
;; 1. We assume we know the way the canonicalizer
;;    works, in order to write the pattern correctly.
;; 2. Sometimes making the data slightly less simple
;;    would enable an operator to match which wouldn't
;;    otherwise -- for instance, letting ?b be zero
;;    below!  
#|
(defIntegration Rat1-integral
  (Integral (/ 1 (+ ?b (* ?a ?var))) ?var)
  :test (and (not (occurs-in? ?var ?a))
	     (not (occurs-in? ?var ?b)))
  :result (/ (log (+ ?b (* ?a ?var)) %e) ?a))

(defIntegration Rat2-integral
  (Integral (/ ?var (+ ?b (* ?a ?var))) ?var)
  :test (and (not (occurs-in? ?var ?a))
	     (not (occurs-in? ?var ?b))
	     (not (zero? ?a)))
  :result (- (/ ?var ?a) (* (/ ?b (sqr ?a)) (log (+ ?b (* ?a ?var))))))

(defIntegration Rat3-Integral
  (Integral (expt (+ ?b (* ?a ?var)) ?n) ?var)
  :test (and (not (occurs-in? ?var ?a))
	     (not (occurs-in? ?var ?b))
	     (not (occurs-in? ?var ?n))
	     (not (same-constant? ?n -1))
	     (not (zero? ?a)))
  :result (/ (expt (+ ?b (* ?a ?var)) (- ?n 1)) (* ?a (+ 1 ?n))))

(defIntegration Rat4-Integral
  (Integral (/ 1 (+ (sqr ?a) (sqr ?var))) ?var)
  :test (and (not (occurs-in? ?var ?a))
	     (not (zero? ?a)))
  :result (/ (atan ?var ?a) ?a))
|#

#|
;;;; Rules which assume derivatives

(defIntegration Deriv-org-rule
  (Integral (/ ?deriv ?func) ?var)
  :test (and (occurs-in? ?var ?func)
	     (alg= ?deriv (derivative-of ?func ?var)))
  :result (log ?func %e))

;;; Can't really do integration by parts:
(integral (* ?u ?dv) ?var) --> (* ?u ?v) - (integral (* ?v ?du) ?var)
where ?dv, ?u contain ?var. and ?du = (derivative-of ?u ?var)
and ?dv = (derivative-of ?v ?var).  Need to search different
combinations of terms in the original product to form ?u and ?dv,
and each such combination would be an instance of this operator.

|#
