;-*- Mode:  LISP; Syntax: Common-lisp -*-

;;; Pattern-directed inference rule for N-queens problem
;;
;; Copyright (c) 1986,1989,1990  Kenneth D. Forbus, All rights reserved.

(rule ((:true (Queen ?column1 ?row1) :var ?Q1)
       (:true (Queen ?column2 ?row2) :var ?Q2
	      :test (and (not (= ?column1 ?column2))
			 (= ?row1 ?row2))))
      (rassert! (not (and ?Q1 ?Q2)) (Row-death ?Q1 ?Q2)))

(rule ((:true (Queen ?column1 ?row1) :var ?q1)
       (:true (Queen ?column2 ?row2) :var ?q2
	      :test (and (not (= ?row1 ?row2))
			 (not (= ?column1 ?column2))
			 (= (abs (- ?column1 ?column2))	
			    (abs (- ?row1 ?row2))))))
      (rassert! (not (and ?q1 ?q2)) (Diagonal-death ?q1 ?q2)))
