#include <LEDA/window.h>
#include <LEDA/stream.h>

#if defined(unix)
const char* small_clock_font = "lucidasans-bold-12";
const char* large_clock_font = "lucidasans-bold-16";
#else
const char* small_clock_font = "B2";
const char* large_clock_font = "B3";
#endif

static panel  main_panel("LEDA Manual Reader");
static window clock_win(58,23);

static string dvi_dir;
static string dtype;
static string lpr_cmd  = "lpr -h";
static string xdvi_cmd = "xdvi -s 4";
static string def_label = "LEDA Manual Reader";

enum { SECONDS = 1, DATE = 2 };

static int   clock_display = DATE;
static color clock_color = black;

string demo_cmd[256];
string demo_label[256];



static int open_panel(panel& p)
{ int x = main_panel.xpos() - 4;
  int y = main_panel.ypos() + main_panel.height() + 6;
  return p.open(x,y);
 }


static bool file_ok(string path, string fname)
{ ifstream fstr(path+fname);
  if (fstr.fail()) 
  { panel error_panel("xlman error",main_panel.width(),-1);
    error_panel.text_item("xlman: cannot open " + fname);
    error_panel.button("continue");
    open_panel(error_panel);
    return false;
   }
  return true;
}

static void view(int)
{ string fname = dtype + ".dvi";
  if (file_ok(dvi_dir,fname))
  { main_panel.set_frame_label("Starting DVI Previewer"); 
    main_panel.flush();
    system(xdvi_cmd + " " + dvi_dir + fname + "&");
    wait(2);
    main_panel.set_frame_label(def_label); 
   }
 }


static void print(int)
{ string fname = dtype + ".ps";
  if (file_ok(dvi_dir,fname))
  { panel pr_panel("LEDA Manual Printer",main_panel.width(),-1);
    pr_panel.string_item("section",dtype);
    pr_panel.string_item("print cmd",lpr_cmd);
    pr_panel.button("print",0);
    pr_panel.button("cancel",1);
  
    if (open_panel(pr_panel) == 0)
    { main_panel.set_frame_label(fname);
      main_panel.flush();
      system(lpr_cmd + " " + dvi_dir + fname);
      main_panel.set_frame_label(def_label); 
     }
   }
}



static void start_demo(int i) 
{ main_panel.set_frame_label("Running  " + demo_label[i]); 
  main_panel.flush();
  system(demo_cmd[i]);
  wait(2);
  main_panel.set_frame_label(def_label); 
 }



#include <time.h>

const char* month[] =
{ "Januar",
  "Februar",
  "Maerz",
  "April",
  "Mai",
  "Juni",
  "Juli",
  "August",
  "September",
  "Oktober",
  "November",
  "Dezember"
 };


static void display_time(window* wp)
{ 
  wp->set_mode(src_mode);
  wp->set_color(clock_color);

  time_t clock; 
  time(&clock);
  tm* T = localtime(&clock); 

  if (T->tm_hour + T->tm_min == 0)
  { def_label = string("%d. %s 19%0d",T->tm_mday,
                                        month[T->tm_mon], T->tm_year%100);
    main_panel.set_frame_label(def_label);
    wp->clear();
   }

  if (clock_display & SECONDS)
      wp->draw_ctext(string("%2d:%02d:%02d",T->tm_hour,T->tm_min,T->tm_sec));
  else
      wp->draw_ctext(string("%2d:%02d",T->tm_hour,T->tm_min));

}



void start_clock(int disp) 
{ 
  if (disp & DATE) 
    { //get date and assignit to def_label
      time_t clock; 
      time(&clock);
      tm* T = localtime(&clock); 
      def_label = string("%d. %s 19%0d",T->tm_mday,
                                        month[T->tm_mon], T->tm_year%100);
     }
  else
    def_label = "LEDA Manual Reader";

  if (disp & SECONDS)
    { clock_win.set_font(small_clock_font);
      clock_win.start_timer(1000,display_time);
     }
  else
    { clock_win.set_font(large_clock_font);
      clock_win.start_timer(60000,display_time);
     }

  main_panel.set_frame_label(def_label);

  clock_display = disp;
  clock_win.clear();
  display_time(&clock_win);
  clock_win.flush();
}



static void setup(int)
{ 
  list<string> choices;
  choices.append("seconds");
  choices.append("date");

  string alarm = "00:00:00";

  panel setup_panel("Xlman Setup Panel",main_panel.width(),-1);
  setup_panel.text_item("");
  setup_panel.text_item("Main Options");
  setup_panel.string_item("Man Path",dvi_dir);
  setup_panel.string_item("View Cmd",xdvi_cmd);
  setup_panel.string_item("Print Cmd",lpr_cmd);
  setup_panel.text_item("");
  setup_panel.text_item("Clock Options");
  setup_panel.color_item("Color",clock_color);
  setup_panel.choice_mult_item("Display",clock_display,choices,start_clock);

  panel_item alarm_it = setup_panel.string_item("Alarm",alarm);

  setup_panel.button("ok",0);
  //setup_panel.button("cancel",1);

  setup_panel.disable_item(alarm_it);

  open_panel(setup_panel);
 }



int main()
{ 
/*
 char* leda_root = getenv("LEDAROOT");

 if (leda_root == 0)
 { cerr << "Environment variable LEDAROOT not defined.";
   exit(1);
  }
*/

 //LEDA::write_log("xlman: LEDA Manual Reader");

 string leda_root = "/LEDA/INSTALL";

 dvi_dir = leda_root + "/Manual/DVI/";

 cmd_istream LS("ls " + dvi_dir + "*.dvi");

 list<string> M;
 M.read(LS);

 if (!M.empty())
 { list_item it;
   forall_items(it,M)
   { string s = M[it];
      s = s.del(dvi_dir);
      s = s.del(".dvi");
      M[it] = s;
    }
  }


  dtype = "Introduction";


  menu demo_menu;

  file_istream demo_table(leda_root + "/DEMO/TABLE");
  int i = 0;
  while (demo_table)
  { demo_table >> demo_label[i];
    if (demo_label[i] == "") break;
    demo_cmd[i].read_line(demo_table);
    demo_menu.button(demo_label[i],i,start_demo);
    i++;
   }


  main_panel.string_item("section",dtype,M);
  main_panel.button("view", 1,view);
  main_panel.button("print",2,print);
  main_panel.button("setup",3,setup);
  main_panel.button("demo",4,demo_menu);
  main_panel.buttons_per_line(5);
  main_panel.display(0,0);

  clock_win.set_text_mode(opaque);
  clock_win.set_redraw(display_time);
  clock_win.display(main_panel,5,6);

  start_clock(clock_display);


  while (main_panel.read() != 0);

 return 0;
}
