/*******************************************************************************
+
+  LEDA 3.5
+
+  color.h
+
+  This file is part of the LEDA research version (LEDA-R) that can be 
+  used free of charge in academic research and teaching. Any commercial
+  use of this software requires a license which is distributed by the
+  LEDA Software GmbH, Postfach 151101, 66041 Saarbruecken, FRG
+  (fax +49 681 31104).
+
+  Copyright (c) 1991-1997  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 66123 Saarbruecken, Germany     
+  All rights reserved.
+ 
*******************************************************************************/

#ifndef LEDA_COLOR_H
#define LEDA_COLOR_H

#if !defined(LEDA_ROOT_INCL_ID)
#define LEDA_ROOT_INCL_ID 350022
#include <LEDA/REDEFINE_NAMES.h>
#endif


#include <LEDA/system.h>
#include <LEDA/bool.h>
#include <LEDA/impl/x_window.h>

/*{\Manpage {color} {} {Colors}}*/

class color {

/*{\Mdefinition
The data type $color$ is the type of all colors available for
drawing operations in windows (cf. \ref{Windows}).
Each color is defined by a triple of integers $(r,g,b)$ with
$0\le r,g,b \le 255$, the so-called {\em rgb-value} of the color.
The number of available colors restricted and depends on the 
underlying hardware. Colors can be created from rgb-values,
from names in a color data base (X11), or from the 16 integer 
constants (enumeration in \<LEDA/incl/impl/x\_window.h\>)
$black$, $white$, $red$, $green$, $blue$, $yellow$, $violet$, $orange$;
$cyan$, $brown$, $pink$, $green2$, $blue2$, $grey1$, $grey2$, $grey3$. 
}*/

  int  col_index;
  bool ok;

public:

/*{\Mcreation col}*/

  color();
/*{\Mcreate  creates a color with rgb-value $(0,0,0)$ (i.e. black). }*/

  color(int r, int g, int b);
/*{\Mcreate  creates a color with rgb-value $(r,g,b)$. }*/

  color(const char* name);
/*{\Mcreate  creates a color and initializes it with the rgb-value
             of color $name$ from the X11 color data base ($(0,0,0)$ 
             if $name$ does not exist). }*/

  color(int i);
/*{\Mcreate  creates a color and initializes it with one of the
             16 predefined colors. Here $i$ is one of the 16 integer
             constants $black$, $white$, $red$, $green$, $blue$, 
             $yellow$, $violet$, $orange$, $cyan$, $brown$, $pink$,                          $green2$, $blue2$, $grey1$, $grey2$, or $grey3$.  }*/


/*{\Moperations 1.5 6}*/

  void set_rgb(int r, int g, int b);
/*{\Mop    sets the rgb-value of |\Mvar| to $(r,g,b)$. }*/

  void get_rgb(int& r, int& g, int& b);
/*{\Mop    assigns the rgb-value of |\Mvar| to $(r,g,b)$. }*/

  void set_red(int r);
/*{\Mop    changes the  r-value of |\Mvar| to $r$. }*/

  void set_green(int g);
/*{\Mop    changes the  g-value of |\Mvar| to $g$. }*/

  void set_blue(int b);
/*{\Mop    changes the  b-value of |\Mvar| to $b$. }*/

  bool is_ok() { return ok; }

  int  get_index()  { return col_index; }

  operator int() const  { return col_index; }

/*
  friend  bool operator==(const color& c1, const color& c2)
  { return c1.col_index == c2.col_index; }
*/
};


#if LEDA_ROOT_INCL_ID == 350022
#undef LEDA_ROOT_INCL_ID
#include <LEDA/UNDEFINE_NAMES.h>
#endif

#endif
