/*******************************************************************************
+
+  LEDA 3.5
+
+  lin_order.h
+
+  This file is part of the LEDA research version (LEDA-R) that can be 
+  used free of charge in academic research and teaching. Any commercial
+  use of this software requires a license which is distributed by the
+  LEDA Software GmbH, Postfach 151101, 66041 Saarbruecken, FRG
+  (fax +49 681 31104).
+
+  Copyright (c) 1991-1997  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 66123 Saarbruecken, Germany     
+  All rights reserved.
+ 
*******************************************************************************/
#ifndef LEDA_LIN_ORDER_H
#define LEDA_LIN_ORDER_H

#if !defined(LEDA_ROOT_INCL_ID)
#define LEDA_ROOT_INCL_ID 350068
#include <LEDA/REDEFINE_NAMES.h>
#endif


//------------------------------------------------------------------------------
// Defining Linear Orders
//------------------------------------------------------------------------------

#define DEFINE_LINEAR_ORDER(type,cmp,new_type)\
struct new_type : public type\
{ new_type(const type& s)     : type(s) {}\
  new_type(const new_type& s) : type(s) {}\
  new_type() {}\
 ~new_type() {}\
};\
inline int compare(const new_type& x, const new_type& y) { return cmp(x,y); }


// INTEGER<cmp>: int with user defined linear order cmp

typedef int (*CMP_INT_TYPE)(const int&, const int&);

template<CMP_INT_TYPE cmp> 
class INTEGER {
  int p;
public:
  INTEGER(int i=0) { p = i;}
  operator int()   { return p; }
  friend int compare(const INTEGER<cmp>& x, const INTEGER<cmp>& y)
  { return cmp(x.p,y.p);}
};


#if LEDA_ROOT_INCL_ID == 350068
#undef LEDA_ROOT_INCL_ID
#include <LEDA/UNDEFINE_NAMES.h>
#endif

#endif
