/*******************************************************************************
+
+  LEDA 3.5
+
+  vga.h
+
+  This file is part of the LEDA research version (LEDA-R) that can be 
+  used free of charge in academic research and teaching. Any commercial
+  use of this software requires a license which is distributed by the
+  LEDA Software GmbH, Postfach 151101, 66041 Saarbruecken, FRG
+  (fax +49 681 31104).
+
+  Copyright (c) 1991-1997  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 66123 Saarbruecken, Germany     
+  All rights reserved.
+ 
*******************************************************************************/


void vga_init(int mode);

int  vga_width();
int  vga_height();
int  vga_depth();

void vga_clear(int col);  

void vga_setpal(int col, int red, int green, int blue);  
void vga_getpal(int col, int* red, int* green, int* blue);  
void vga_set_mode(int mode);
void vga_set_color(int col);
void vga_set_buffering(int b);

// drawing
void vga_pixel(int x, int y,int flush=0);
void vga_hline(int x0, int x1, int y);
void vga_vline(int x, int y0, int y1);
void vga_bitmap(int left, int top, unsigned char* pm, int width, int height);
void vga_box(int x0, int y0, int x1, int y1);
void vga_flush(int x0, int y0, int x1, int y1, int=0);


// bitmaps

unsigned char* vga_getimage(int left, int top, int w, int h);

void  vga_putimage(int x, int y,  int w, int h, unsigned char* image);
void  vga_delimage(unsigned char* image);
void  vga_copyimage(int left,int top,int w,int h,int x,int y);

// events

int  vga_next_event(int* val, int* x, int* y, int block);
void vga_back_event();
void vga_draw_pointer(int x, int y, int x_old, int y_old);

