
#line 897 "ext.nw"
sub print_unit{
   local($text) = @_; # read argument into local variable
   print OUTPUT $text,"\n\n";
}

#line 912 "ext.nw"
sub convert_text{
  local($text) = @_; # read argument into local variable
  $text = &substitute_for_placeholders($text);
  $text = &web_to_latex($text);
  if ($kind eq "Cweb")
    { 
#line 922 "ext.nw"
  
local($i, $remline, $outline, $lines , $word); 
@lines = split(/^/,$text);  # split at new lines
$text = "";
foreach $i (0 .. $#lines)
  {if (length($lines[$i]) > 80)
     { $outline = "";
       $remline = $lines[$i];
       while ($remline )            
         { if ($remline =~ /[\w\,] /) 
             {  $word = $` . $&; $remline = $';}
           else {$word = $remline; $remline = ""; }
           # a word charachter or komma followed by a blank or the entire line
           if (length($outline) + length($word) < 80)
             {$outline  .= $word;}
           else 
             {if ($outline) { $text .= $outline . "\n"; }
              else { &print_warning("unable to break line, might cause trouble with cweave\n$word\n\n");}
              $outline = $word;
             }
          }
       $text .= $outline;   # no newline here
      }
   else { $text .= $lines[$i]; }   # no newline here
 }  

#line 917 "ext.nw"
                                             }
  $text;
}


#line 957 "ext.nw"
sub substitute_for_placeholders{
  local($string) = @_;
  $string =~ s/\\Mvar/$Mvar/g;
  $string =~ s/\\Mtype/$Mtype/g;
  $string =~ s/\\Mname/$Mname/g;
  foreach $key (keys(%map))  # for each key  in the substitution map
     { $string =~ s/$key/$map{$key}/g; }
  
  if ($string =~ /\\var\W/ || $string =~ /Mvar/) {&print_warning("found an occurrence of \\var or an unslashed occurrence of Mvar. Did you mean \\Mvar?");}
  if ($string =~ /\\type\W/ || $string =~ /Mtype/) {&print_warning("found an occurrence of \\type or an unslashed occurrence of Mtype. Did you mean \\Mtype?");}
  if  ($string =~ /\\nameW/ || $string =~ /Mname/) {&print_warning("found an occurrence of \\name or an unslashed occurrence of Mname. Did you mean \\Mname?");}

  $string;
}

#line 979 "ext.nw"
sub web_to_latex{
  local($text) = @_; # read argument into local variable
  local($output) = "";
  while ($text)
    { $text =~ /^([^\n]*\n)/;
      $text = $';
      $output .= &convert_line($1);
    } 
    return $output;
}


#line 2504 "ext.nw"
sub convert_line{
  local($text) = @_; # read argument into local variable
  local($output) = "";
  chop($text);
iteration:
   while ($text)
    { if ($text =~ /^([^\\\[\|]+)/)  # does not start with [ or | or \
        { $text = $';
          $output .= $1;
          if ($text eq "") { last iteration;}
        } 
      # text is nonempty and starts with [ or | or \       
      if ($text =~ /^\\Mcode(.)/)
       { $text = $';
         $delimiter=$1;
         if (!($text =~ /\\$1/))  # \ to protext meta characters
            {&print_warning("Mcode extends beyond end of line");}
         $text = $';
         $output .= &convert_M($`);
         next iteration;
       }
      if ($text =~ /^\\Tcode(.)/)
       { $text = $';
         $delimiter=$1;
         if (!($text =~ /\\$1/))  # as above
           {&print_warning("Tcode extends beyond end of line");}
         $text = $';
         $output .= &convert_T($`);
         next iteration;
       }
      # next we deal with | in its exceptional meanings
      if ($text =~ /^\\begin\{tabular\}/)
       {  $output .= $text;
          last iteration;
       }     
      if ($text =~ /^\\left\|/)
       { $text = $';
         $output .= "\\left\|";
       }
      if ($text =~ /^\\right\|/)
       { $text = $';
         $output .= "\\right\|";
       }
      if ($text =~ /^\|/)
       { $text = $';
         if (!($text =~ /\|/)) { &print_warning("odd number of |:\n|$text\n\n");}
         $text = $';
         $output .= &convert_M($`);
         next iteration;
       }
      if ($text =~ /^\[\[/)
       { $text = $';
         if (!($text =~ /\]\]/))
           { &print_warning("encountered [[ without matching ]]:[[$text\n\n");}
         $code = $`;  
         $text = $';
         while ($code =~ /\]\]/)
           { $code = $`;
             $text = $' . "]]" . $text;
           }
         $output .= &convert_T($code);;
         next iteration;
       }
     
      # text does not start with a special symbol. Move first symbol to output.
      $text =~ /^(.)/;
      $output .= $1;
      $text = $';
    }
  return $output . "\n";
}
         

#line 2630 "ext.nw"
# the following procedure is copied from ext.nw. Please make changes only here.
# I still need  way to maintain consistency with ext.

sub convert_M{
 local($Ctext) = @_; # read argument into local variable
   # we first work on identifiers 
   local($prefix) = "";
   local($suffix) = $Ctext;
   local($ident) = "";
identloop:
   while ($suffix =~ /^(\W*)(\w.*)$/)
     { $prefix .= $1;
       $suffix = $2;
       if ( $suffix =~ /^(\w+)(\W.*)$/)
         { $ident = $1;
           $suffix = $2;
         }
       else 
          { $ident = $suffix;
            $suffix = "";
          }
       if ($prefix =~ /\\$/) # For things like \n
          { if ($ident ne "n") {&print_warning("huch:\\ in  quoted code");}
            $prefix .= "L" . $ident; next identloop;
          }
       if ($ident =~ /^[0-9]*$/ )   # just a number
          { $prefix .= $ident; next identloop;}
       if (($usesubscripts eq "yes") && ($ident =~ /^([a-zA-Z])([0-9]+)$/)) 
             { $ident = $1 ."\\underscore\{$2\}"; }
           else { $ident = "\\mathit\{$ident\}"; }
       $prefix .= $ident;
        
      }
   $Ctext = $prefix . $suffix;
   $Ctext =~ s/&/\\&/g;
   $Ctext =~ s/_/\\nspaceunderscore\\_/g; # small negative space before _
   $Ctext =~ s/\./\\nspacedot\./g;  # small negative space before .
   $Ctext =~ s/::/\\DP /g;
   $Ctext =~ s/<</\\ll/g;
   $Ctext =~ s/>>/\\gg/g;
   $Ctext =~ s/ *<= */\\Lle/g;
   $Ctext =~ s/ *>= */\\Lge/g;
   $Ctext =~ s/ *== */\\Leq/g;
   $Ctext =~ s/ *-> */\\Larrow/g;
   $Ctext =~ s/ *\+ */+/g;   # LaTeX takes care of the spacing
   $Ctext =~ s/ *- */-/g;
   $Ctext =~ s/ *\* +/\*/g;
   $Ctext =~ s/ *< */</g;
   $Ctext =~ s/ *> */>/g;
   # All blanks that are still in Ctext are to be preserved and are hence quoted
   $Ctext =~ s/ /\\ /g;
   $Ctext =~ s/\+\+/\\Dplus /g;
   $Ctest =~ s/--/\\Dminus /g;
   $Ctext =~ s/!=/\\Noteq /g;
   $Ctext =~ s/\\Lle/\\Lle /g;
   $Ctext =~ s/\\Lge/\\Lge /g;
   $Ctext =~ s/\\Leq/\\Leq /g;
   $Ctext =~ s/\\Larrow/\\Larrow /g;
   if ($Ctext =~ /</) 
   { while ($Ctext =~ /^(.*)<([^>]*)>(.*)$/) # template brackets
     { $Ctext =~ s/</\\Lless /g; 
       $Ctext =~ s/>/\\Lgreater /g;
     }
   }
   $Ctext =~ s/%/\\%/g; 
   $Ctext =~ s/\^/\\circumflexop /g;
   $Ctext =~ s/~/\\tildeop /g;
   $Ctext =~ s/'/\\Lrquote /g;
   $Ctext =~ s/`/\\Llquote /g; 
   $Ctext =~ s/\(\)/\(\\;\)/g;      # a little space for empty argument list
   $Ctext =~ s/\,\\ /\,\$\}\n\\mbox\{\$/g;  
       # replace ,blank by ,$}newline\mbox{$ to allow line breaks
   $Ctext = "\\mbox\{\$" . $Ctext . "\$\}";

 $Ctext;
}
  

#line 2744 "ext.nw"
# the following procedure is copied from ext.nw. Please make changes only here.
# I still need  way to maintain consistency with ext.

sub convert_T{
 local($Ctext) = @_; # read argument into local variable
 $Ctext =~ s/&/\\&/g;
 $Ctext =~ s/_/\\_/g;
 $Ctext =~ s/{/\\{/g;
 $Ctext =~ s/}/\\}/g;
 $Ctext =~ s/%/\\%/g; 
 $Ctext =~ s/\^/\\circumflexop /g;
 $Ctext =~ s/~/\\Tildeop /g; 
 return "\{\\tt " . $Ctext . "\}";
}





#line 1542 "ext.nw"
sub print_function{
@args = ("funcname","prefix","postfix","signature","type");
foreach $arg (@args)
{ foreach $key (keys(%map)) 
     {$$arg =~ s/$key/$map{$key}/g; }
} 
if ($mode eq "Fman")
 { if ($funcname) {$signature = $prefix . $funcname . "(". $postfix. ")";}
   print $type , " ", $signature , "\n" ;
   if ($showsem == 1) 
   { print &substitute_for_placeholders($Mcomment) , "\n\n"; }
   return;
 }

$arg1 = "";  # conversion functions have no return type
$arg4 = "";  # description may be empty

if ($type) { $arg1 = &convert_M($type);}

$arg2 = "";
if ($funcname)
  { if ($prefix) { $arg2 .= &convert_M($prefix);}
    $funcname =~ s/_/\\nspaceunderscore\\_/g;  # quote and back up slightly
    $arg2 .= $funcname;
    if ($postfix =~ /^ *$/) {$arg3 = "";}
    else {$arg3 = &convert_M($postfix);}
   }
else
  { $arg2 =   &convert_M($signature);
    $arg3 = "";
  }

if ($Mcomment && $showsem == 1) {$arg4 = &convert_text($Mcomment);}
 
local($text) = "";
if ($command =~ /^opl?/ || $command =~ /^funcl?/ || $command =~ /^staticl?/)
 {  if ($arg3 eq "") {$arg3 = "\$\\,\$"; } # small space
    $text = "\\function" .' {'. $arg1 . "\}\n\{". $arg2 ."\} \n\{". $arg3 . "\} \n\{" . $arg4 .'}';
 }
else 
 { $text = "\\operator" .' {'. $arg1 . "\}\n\{". $arg2 ."\}  \n\{" . $arg4 .'}'; }

print OUTPUT $text,"\n\n";

}

#line 1594 "ext.nw"
sub print_constructor{
@args = ("par_list");
foreach $arg (@args)
   { foreach $key (keys(%map)) 
     {$$arg =~ s/$key/$map{$key}/g; }
   } 
if (!$Mvar || !$Mname )
     {&print_warning("ERROR: You forgot to define either Mvar or Mname");}
if ($mode eq "Fman")
    { $signature = $Mname . " " . $Mvar;
      if ($par_list) { $signature .= "(" . $par_list. ")"; }
      print $signature , ";\n" , &substitute_for_placeholders($Mcomment) , "\n\n";
      return;
    }
$arg1 = &convert_M($Mname);
$arg2 = &convert_M($Mvar);
if ($par_list)
    { $arg3 = &convert_M($par_list);}
else
    { $arg3 = "";}  # empty arg list
  
$arg4 = &convert_text($Mcomment);

local($text) = "\\create" .' {'. $arg1 ."\}\n\{". $arg2 ."\} \n\{".$arg3 . "} \n\{".$arg4 .'}';

print OUTPUT $text,"\n\n";

}

#line 1629 "ext.nw"
sub print_destructor{

 if ($mode eq "Fman")
 { print "~", $Mname ,"()\n" , &substitute_for_placeholders($Mcomment) ,"\n\n";
 }

  $arg1 = &convert_M($Mname);
     
  $arg2 = &convert_text($Mcomment);

  local($text) = "\\destruct" .' {'. $arg1 ."\}\n\{". $arg2 ."\}\n";

  print OUTPUT $text,"\n\n";
}

#line 2031 "ext.nw"
sub error_handler{
local($text) =  @_;  # read argument into local variable
print STDOUT "A problem occured near line " , $. ,"\n";
print STDOUT $text,"\n\n";
print STDOUT "The current code unit is:\n";
print STDOUT $original_code_unit, "\n";
print STDOUT "The current manual comment is:\n";
print STDOUT $original_comment, "\n\n";
if ($ack eq "yes") { print STDOUT "*  ";
            read(STDIN,$meaningless,1); }
}

sub print_warning{
if ($warnings eq "no" || $nextwarning eq "no") {return;}
local($text) =  @_;  # read argument into local variable
print STDOUT "A problem occured near line " , $. ,"\n";
print STDOUT "WARNING: ",$text,"\n\n";
print STDOUT "The current code unit is:\n\n";
print STDOUT $original_code_unit, "\n";
print STDOUT "The current manual comment is:\n\n";
print STDOUT $original_comment, "\n\n";
if ($ack eq "yes") { print STDOUT "*  ";
            read(STDIN,$meaningless,1); }
}


#line 2067 "ext.nw"
sub remove_enclosing_blanks{
if ($_[0] =~ /^ *$/)  {$_[0] = "";}
else
  { 
    $_[0] =~ / *(.*[^ ]) *$/; 
    $_[0] = $1;   
  }
}



#line 2083 "ext.nw"
sub print_usage{
if ($mode eq "Lman" || $mode eq "Ldoc")
{ print "\n\n\n
usage is
         Lman|Ldoc file [options]
Options are given in assignment syntax variable=value. There must be no
blank on either side of the equality sign. We list all variables and 
their possible values below. For each variable the default value of 
each option is given first.

size={12,11,10}
constref={no,yes}
partypes={no,yes}
numbered={no,yes}
xdvi={yes,no}
warnings={yes,no}
ack={yes,no}
usesubscripts={no,yes}
latexruns={1,2,0}
delman={yes,no}
filter={all,signatures,definition,creation,operations,
implementation,example,opname}

Lman and Ldoc can be customized by putting options in a 
file Lman.cfg or Ldoc.cfg 
in either 
the home directory or the working directory.

Call Lman Lman or Lman Ldoc for more information.  

call\n\n\n";
}
if ($mode eq "Fman")
{ print "\n\n\n
usage is
         Fman file filter

where the file name is of the form T[.h/.w] and T is either 
the name of a LEDA type, e.g., list, sortseq, or point, or 
the name of a user defined data type. The value of filter is one of {all,signatures,definition,creation,operations,
implementation,example,opname}" ;
}
exit;
}



#line 2279 "ext.nw"
$INPUT = $ARGV[0] && shift;
$OUTPUT = $ARGV[0];

if ($OUTPUT eq "")
{print "usage

              ldel infile outfile              

removes manual comments from infile 
";
die;
}

open (INPUT)  || die "Can't find input file $INPUT: $!\n";
open(OUTPUT,">$OUTPUT");

    while (<INPUT>)
    { # The current line is either output or starts a manual comment
      $preamble = 0;
      if ( / *\/\*\{\\M/ )
      {  # current line contains the begin of a manual comment
         # we need to distinguish cases: if the manual comment is 
         # Mpreamble then we proceed as in the manual extraction and
         # otherwise we simply delete the manual comment.
         if ( s/ *\/\*\{\\Mpreamble// ) {$Mcomment = $_; $preamble = 1;}
         # we scan lines until we find the end of a manual comment
         while ($_ && (! ( /\}\*\// ) ) )
           { if ($preamble == 1) {$Mcomment .= $_;}
             $_ = <INPUT>; 
           }
         # the current line contains the end of a manual comment
         if ($preamble == 1) 
           { s/\}\*\/ *//; 
             $Mcomment .= $_;
             &print_unit(&convert_text($Mcomment));
           }
       }
       else { print OUTPUT $_; }
     }
  
close(OUTPUT);

