\begin{manual}
\definition

An instance $L$ of the parameterized data type \mbox{$\mathit{list}\Lless \mathit{E}\Lgreater $} is a sequence of items
($list\_item$). Each item in $L$ contains an element of data type $E$, called
the element type of $L$. The number of items in $L$ is called the length of $L$.
If $L$ has length zero it is called the empty list. In the sequel $\<x\>$ is 
used to denote a list item containing the element $x$ and $L[i]$ is used to 
denote the contents of list item $i$ in $L$. 


\creation

\create {\mbox{$\mathit{list}\Lless \mathit{E}\Lgreater $}}
{\mbox{$\mathit{L}$}} 
{} 
{creates  an instance \mbox{$\mathit{L}$} of type \mbox{$\mathit{list}\Lless \mathit{E}\Lgreater $} and initializes it to 
            the empty list. 
}

\setlength{\typewidth}{2cm}
\setlength{\callwidth}{5cm}
\computewidths
\operations


\medskip
{\bf 3.1 Access Operations}
\medskip  


\function {\mbox{$\mathit{int}$}}
{\mbox{$\mathit{L}\nspacedot.$}length} 
{$\,$} 
{returns the length of $L$. 
}

\function {\mbox{$\mathit{int}$}}
{\mbox{$\mathit{L}\nspacedot.$}size} 
{$\,$} 
{returns $L$.length(). 
}

\function {\mbox{$\mathit{bool}$}}
{\mbox{$\mathit{L}\nspacedot.$}empty} 
{$\,$} 
{returns true if $L$ is empty, false otherwise. 
}

\function {\mbox{$\mathit{list\nspaceunderscore\_item}$}}
{\mbox{$\mathit{L}\nspacedot.$}first} 
{$\,$} 
{returns the first item of $L$ (nil if $L$ is empty). 
}

\function {\mbox{$\mathit{list\nspaceunderscore\_item}$}}
{\mbox{$\mathit{L}\nspacedot.$}last} 
{$\,$} 
{returns the last item of $L$. (nil if $L$ is empty) 
}

\function {\mbox{$\mathit{list\nspaceunderscore\_item}$}}
{\mbox{$\mathit{L}\nspacedot.$}item} 
{\mbox{$\mathit{int}\ \mathit{i}$}} 
{returns the item at position $i$ (the first position is 0).\\
             \precond $i < L$.length(). 
}

\function {\mbox{$\mathit{list\nspaceunderscore\_item}$}}
{\mbox{$\mathit{L}\nspacedot.$}succ} 
{\mbox{$\mathit{list\nspaceunderscore\_item}\ \mathit{it}$}} 
{returns the successor item of item $it$, nil if
	     $it=L$.last().\\
	     \precond $it$ is an item in $L$. 
}

\function {\mbox{$\mathit{list\nspaceunderscore\_item}$}}
{\mbox{$\mathit{L}\nspacedot.$}pred} 
{\mbox{$\mathit{list\nspaceunderscore\_item}\ \mathit{it}$}} 
{returns the predecessor item of item $it$, nil if
	     $it=L$.first().\\
	     \precond $it$ is an item in $L$. 
}

\function {\mbox{$\mathit{list\nspaceunderscore\_item}$}}
{\mbox{$\mathit{L}\nspacedot.$}cyclic\nspaceunderscore\_succ} 
{\mbox{$\mathit{list\nspaceunderscore\_item}\ \mathit{it}$}} 
{returns the cyclic successor of item $it$, i.e.,
	     $L$.first() if $it = L$.last(), $L$.succ($it$) otherwise. 
}

\function {\mbox{$\mathit{list\nspaceunderscore\_item}$}}
{\mbox{$\mathit{L}\nspacedot.$}cyclic\nspaceunderscore\_pred} 
{\mbox{$\mathit{list\nspaceunderscore\_item}\ \mathit{it}$}} 
{returns the cyclic predecessor of item $it$, i.e,
             $L$.last() if $it = L$.first(), $L$.pred($it$) otherwise. 
}

\function {\mbox{$\mathit{list\nspaceunderscore\_item}$}}
{\mbox{$\mathit{L}\nspacedot.$}search} 
{\mbox{$\mathit{E}\ \mathit{x}$}} 
{returns the first item of $L$ that contains $x$,
	     nil if $x$ is not an element of $L$.\\
	     \precond{compare has to be defined for type $E$.}  
}

\function {\mbox{$\mathit{E}$}}
{\mbox{$\mathit{L}\nspacedot.$}contents} 
{\mbox{$\mathit{list\nspaceunderscore\_item}\ \mathit{it}$}} 
{returns the contents $L[it]$ of item $it$.\\
	     \precond $it$ is an item in $L$. 
}

\function {\mbox{$\mathit{E}$}}
{\mbox{$\mathit{L}\nspacedot.$}inf} 
{\mbox{$\mathit{list\nspaceunderscore\_item}\ \mathit{it}$}} 
{returns $L$.contents($it$). 
}

\function {\mbox{$\mathit{E}$}}
{\mbox{$\mathit{L}\nspacedot.$}head} 
{$\,$} 
{returns the first element of $L$, i.e. the contents
	     of $L$.first().\\
	     \precond $L$ is not empty. 
}

\function {\mbox{$\mathit{E}$}}
{\mbox{$\mathit{L}\nspacedot.$}tail} 
{$\,$} 
{returns the last element of $L$, i.e. the contents
	     of $L$.last().\\
	     \precond $L$ is not empty. 
}

\function {\mbox{$\mathit{int}$}}
{\mbox{$\mathit{L}\nspacedot.$}rank} 
{\mbox{$\mathit{E}\ \mathit{x}$}} 
{returns the rank of $x$ in $L$, i.e. its first
	     position in $L$ as an integer from [1\dots $\Labs{L}$]
	     (0 if $x$ is not in $L$).  
}


\medskip
{\bf 3.2 Update Operations}
\medskip  


\function {\mbox{$\mathit{list\nspaceunderscore\_item}$}}
{\mbox{$\mathit{L}\nspacedot.$}push} 
{\mbox{$\mathit{E}\ \mathit{x}$}} 
{adds a new item $\<x\>$ at the front of $L$ and 
	     returns it ( $L$.insert($x,L$.first$(),before$) ). 
}

\function {\mbox{$\mathit{list\nspaceunderscore\_item}$}}
{\mbox{$\mathit{L}\nspacedot.$}append} 
{\mbox{$\mathit{E}\ \mathit{x}$}} 
{appends a new item $\<x\>$ to $L$ and returns
             it ( $L$.insert($x,L$.last$(),after$) ). 
}

\function {\mbox{$\mathit{list\nspaceunderscore\_item}$}}
{\mbox{$\mathit{L}\nspacedot.$}insert} 
{\mbox{$\mathit{E}\ \mathit{x},$}
\mbox{$\mathit{list\nspaceunderscore\_item}\ \mathit{l},$}
\mbox{$\mathit{int}\ \mathit{dir}=\mathit{after}$}} 
{inserts a new item $\<x\>$ after (if $dir=after$)
	     or before (if $dir=before$) 
	     item $it$ into $L$ and
	     returns it
	     (here $after$ and $before$
	     are predefined $int$ constants).\\ 
	     \precond $it$ is an item in $L$. 
}

\function {\mbox{$\mathit{E}$}}
{\mbox{$\mathit{L}\nspacedot.$}pop} 
{$\,$} 
{deletes the first item from $L$ and returns its
  	     contents.\\
	     \precond $L$ is not empty. 
}

\function {\mbox{$\mathit{E}$}}
{\mbox{$\mathit{L}\nspacedot.$}Pop} 
{$\,$} 
{deletes the last item from $L$ and returns its
	     contents.\\
	     \precond $L$ is not empty. 
}

\function {\mbox{$\mathit{E}$}}
{\mbox{$\mathit{L}\nspacedot.$}del\nspaceunderscore\_item} 
{\mbox{$\mathit{list\nspaceunderscore\_item}\ \mathit{it}$}} 
{deletes the item $it$ from $L$ and returns its
	     contents $L[it]$.\\
	     \precond $it$ is an item in $L$. 
}

\function {\mbox{$\mathit{void}$}}
{\mbox{$\mathit{L}\nspacedot.$}move\nspaceunderscore\_to\nspaceunderscore\_front} 
{\mbox{$\mathit{list\nspaceunderscore\_item}\ \mathit{it}$}} 
{moves $it$ to the front end of $L$.  
}

\function {\mbox{$\mathit{void}$}}
{\mbox{$\mathit{L}\nspacedot.$}move\nspaceunderscore\_to\nspaceunderscore\_rear} 
{\mbox{$\mathit{list\nspaceunderscore\_item}\ \mathit{it}$}} 
{moves $it$ to the rear end of $L$.  
}

\function {\mbox{$\mathit{void}$}}
{\mbox{$\mathit{L}\nspacedot.$}assign} 
{\mbox{$\mathit{list\nspaceunderscore\_item}\ \mathit{it},$}
\mbox{$\mathit{E}\ \mathit{x}$}} 
{makes $x$ the contents of item $it$.\\
	     \precond $it$ is an item in $L$. 
}

\function {\mbox{$\mathit{void}$}}
{\mbox{$\mathit{L}\nspacedot.$}conc} 
{\mbox{$\mathit{list}\Lless \mathit{E}\Lgreater \&\ \mathit{L1}$}} 
{appends list $L_1$ to list $L$ and makes $L_1$ the
	     empty list.\\
	     \precond: $L \ne L_1$ 
}

\function {\mbox{$\mathit{void}$}}
{\mbox{$\mathit{L}\nspacedot.$}split} 
{\mbox{$\mathit{list\nspaceunderscore\_item}\ \mathit{it},$}
\mbox{$\mathit{list}\Lless \mathit{E}\Lgreater \&\ \mathit{L1},$}
\mbox{$\mathit{list}\Lless \mathit{E}\Lgreater \&\ \mathit{L2}$}} 
{splits $L$ at item $it$ into lists $L1$ and $L2$. More precisely,
	     if $it \ne nil$ and $ L = x_1,\dots,x_{k-1},it,x_{k+1},\dots,x_n$
             then $L1 = x_1,\dots,x_{k-1}$ and $L2 = it,x_{k+1},\dots,x_n$. If
             $it = nil$ then $L1$ is made empty and $L2$ a copy of $L$. Finally
             $L$ is made empty if it is not identical to $L1$ or $L2$.\\
	     \precond $it$ is an item of $L$ or $nil$. 
}

\function {\mbox{$\mathit{void}$}}
{\mbox{$\mathit{L}\nspacedot.$}split} 
{\mbox{$\mathit{list\nspaceunderscore\_item}\ \mathit{it},$}
\mbox{$\mathit{list}\Lless \mathit{E}\Lgreater \&\ \mathit{L1},$}
\mbox{$\mathit{list}\Lless \mathit{E}\Lgreater \&\ \mathit{L2},$}
\mbox{$\mathit{int}\ \mathit{dir}$}} 
{splits $L$ at item $it$ into lists $L1$ and $L2$. Item $it$ 
             becomes the first item of $L2$ if $dir==0$ and the last item
             of $L1$ otherwise.\\ \precond $it$ is an item of $L$. 
}

\function {\mbox{$\mathit{void}$}}
{\mbox{$\mathit{L}\nspacedot.$}sort} 
{\mbox{$\mathit{int}\ (*\mathit{cmp})(\mathit{const}\ \mathit{E}\&\ ,$}
\mbox{$\mathit{E}\ )$}} 
{sorts the items of $L$ using the ordering defined
	     by the compare function $cmp : E\times E \longrightarrow int$,
	     with\\
 	     $$cmp(a,b)\ \ \cases{< 0,  &if $a < b$\cr
		                  = 0,  &if $a = b$\cr
		                  > 0,  &if $a > b$\cr}$$
	     More precisely, if $(in_1,\dots,in_n)$ and 
	     $(out_1,\dots,out_n)$ denote the values of $L$
	     before and after the call of sort, then
	     $cmp(L[out_j], L[out_{j+1}]) \le 0$ for
	     $1\le j<n$ and there is a
	     permutation
	     $\pi$ of $[1..n]$ such that $out_i = in_{\pi_i}$ for
	     $1 \le i \le n$
	     . 
}

\function {\mbox{$\mathit{void}$}}
{\mbox{$\mathit{L}\nspacedot.$}sort} 
{$\,$} 
{sorts the items of $L$ using the default ordering of type $E$,
             i.e., the linear order defined by function 
             $int$ compare$(const\ E\&,\ const\ E\&)$.  
}

\function {\mbox{$\mathit{list\nspaceunderscore\_item}$}}
{\mbox{$\mathit{L}\nspacedot.$}min} 
{\mbox{$\mathit{int}\ (*\mathit{cmp})(\mathit{const}\ \mathit{E}\&\ ,$}
\mbox{$\mathit{E}\ )$}} 
{returns the item with the minimal contents with respect
             to the linear order defined by compare function $cmp$.  
}

\function {\mbox{$\mathit{list\nspaceunderscore\_item}$}}
{\mbox{$\mathit{L}\nspacedot.$}min} 
{$\,$} 
{returns the item with the minimal contents with respect
             to the default linear order of type $E$.  
}

\function {\mbox{$\mathit{list\nspaceunderscore\_item}$}}
{\mbox{$\mathit{L}\nspacedot.$}max} 
{\mbox{$\mathit{int}\ (*\mathit{cmp})(\mathit{const}\ \mathit{E}\&\ ,$}
\mbox{$\mathit{E}\ )$}} 
{returns the item with the maximal contents with respect
             to the linear order defined by compare function $cmp$.  
}

\function {\mbox{$\mathit{list\nspaceunderscore\_item}$}}
{\mbox{$\mathit{L}\nspacedot.$}max} 
{$\,$} 
{returns the item with the maximal contents with respect
             to the default linear order of type $E$.  
}

\function {\mbox{$\mathit{void}$}}
{\mbox{$\mathit{L}\nspacedot.$}apply} 
{\mbox{$\mathit{void}\ (*\mathit{f})(\mathit{E}\&\ \mathit{x})$}} 
{for all items $\<x\>$ in $L$ function $f$ is
	     called with argument $x$ (passed by reference). 
}

\function {\mbox{$\mathit{void}$}}
{\mbox{$\mathit{L}\nspacedot.$}bucket\nspaceunderscore\_sort} 
{\mbox{$\mathit{int}\ \mathit{i},$}
\mbox{$\mathit{int}\ \mathit{j},$}
\mbox{$\mathit{int}\ (*\mathit{f})(\mathit{const}\ \mathit{E}\&\ )$}} 
{sorts the items of $L$ using bucket sort,
	     where $f : E \longrightarrow int$ with $f(x) \in [i..j]$ for
	     all elements $x$ of $L$. The sort is stable,
	     i.e., if $f(x)=f(y)$ and $\<x\>$ is before $\<y\>$ in
	     $L$ then $\<x\>$ is before $\<y\>$ after the sort. 
}

\function {\mbox{$\mathit{void}$}}
{\mbox{$\mathit{L}\nspacedot.$}permute} 
{$\,$} 
{the items of $L$ are randomly permuted. 
}

\function {\mbox{$\mathit{void}$}}
{\mbox{$\mathit{L}\nspacedot.$}clear} 
{$\,$} 
{makes $L$ the empty list.  
}


\bigskip
{\bf 3.3 Input and Output}  


\function {\mbox{$\mathit{void}$}}
{\mbox{$\mathit{L}\nspacedot.$}read} 
{\mbox{$\mathit{istream}\&\ \mathit{I},$}
\mbox{$\mathit{char}\ \mathit{delim}\ =\ (\mathit{char})\mathit{EOF}$}} 
{reads a sequence of objects of type $E$ terminated
	     by the delimiter $delim$ from the input stream $I$
	     using the overloaded $Read$ function 
	     (section \ref{Overloading}).
	     $L$ is made a list of appropriate length and the
	     sequence is stored in $L$. 
}

\function {\mbox{$\mathit{void}$}}
{\mbox{$\mathit{L}\nspacedot.$}read} 
{\mbox{$\mathit{char}\ \mathit{delim}\ =\ \Lrquote \Ln\Lrquote $}} 
{calls $L$.read($cin$, $delim$) to read $L$ from
	     the standard input stream $cin$. 
}

\function {\mbox{$\mathit{void}$}}
{\mbox{$\mathit{L}\nspacedot.$}read} 
{\mbox{$\mathit{string}\ \mathit{s},$}
\mbox{$\mathit{char}\ \mathit{delim}\ =\ \Lrquote \Ln\Lrquote $}} 
{As above, but uses string $s$ as a prompt. 
}

\function {\mbox{$\mathit{void}$}}
{\mbox{$\mathit{L}\nspacedot.$}print} 
{\mbox{$\mathit{ostream}\&\ \mathit{O},$}
\mbox{$\mathit{char}\ \mathit{space}\ =\ \Lrquote \ \Lrquote $}} 
{prints the contents of list $L$ to the output
	     stream $O$ using the overload $Print$ function
	     (cf.~section \ref{Overloading}) to print each element. The 
	     elements are separated by the character $space$. 
}

\function {\mbox{$\mathit{void}$}}
{\mbox{$\mathit{L}\nspacedot.$}print} 
{\mbox{$\mathit{char}\ \mathit{space}\ =\ \Lrquote \ \Lrquote $}} 
{calls $L$.print($cout$, $space$) to print $L$ on
	     the standard output stream $cout$. 
}

\function {\mbox{$\mathit{void}$}}
{\mbox{$\mathit{L}\nspacedot.$}print} 
{\mbox{$\mathit{string}\ \mathit{s},$}
\mbox{$\mathit{char}\ \mathit{space}\ =\ \Lrquote \ \Lrquote $}} 
{As above, but uses string $s$ as a header. 
}


\medskip
{\bf 3.4 Iterators }

Each list $L$ has a special item called the iterator of $L$. There 
are operations to read the current value or the contents of this iterator,
to move it (setting it to its successor or predecessor) and to test whether 
the end (head or tail) of the list is reached. If the iterator contains a 
$list\_item \neq nil$ we call this item the position of the iterator. 
Iterators are used to implement iteration statements on lists.  


\function {\mbox{$\mathit{void}$}}
{\mbox{$\mathit{L}\nspacedot.$}set\nspaceunderscore\_iterator} 
{\mbox{$\mathit{list\nspaceunderscore\_item}\ \mathit{it}$}} 
{assigns item $it$ to the iterator.\\
	     \precond $it$ is in $L$ or $it$ = nil.  
}

\function {\mbox{$\mathit{void}$}}
{\mbox{$\mathit{L}\nspacedot.$}init\nspaceunderscore\_iterator} 
{$\,$} 
{assigns nil to the iterator. 
}

\function {\mbox{$\mathit{list\nspaceunderscore\_item}$}}
{\mbox{$\mathit{L}\nspacedot.$}get\nspaceunderscore\_iterator} 
{$\,$} 
{returns the current value of the iterator. 
}

\function {\mbox{$\mathit{list\nspaceunderscore\_item}$}}
{\mbox{$\mathit{L}\nspacedot.$}move\nspaceunderscore\_iterator} 
{\mbox{$\mathit{int}\ \mathit{dir}$}} 
{moves the iterator to its successor (predecessor)
	     if $dir=forward$ ($backward$) and to the first 
	     (last) item if the iterator is undefined (= nil), returns
	     the value of the iterator. 
}

\function {\mbox{$\mathit{bool}$}}
{\mbox{$\mathit{L}\nspacedot.$}current\nspaceunderscore\_element} 
{\mbox{$\mathit{E}\&\ \mathit{x}$}} 
{if the iterator is defined ($\neq$ nil) its contents is
             assigned to $x$ and true is returned else false
	     is returned. 
}

\function {\mbox{$\mathit{bool}$}}
{\mbox{$\mathit{L}\nspacedot.$}next\nspaceunderscore\_element} 
{\mbox{$\mathit{E}\&\ \mathit{x}$}} 
{calls $L$.move\_iterator($forward$) and then  
	     returns $L$.current\_element($x$).  
}

\function {\mbox{$\mathit{bool}$}}
{\mbox{$\mathit{L}\nspacedot.$}prev\nspaceunderscore\_element} 
{\mbox{$\mathit{E}\&\ \mathit{x}$}} 
{calls $L$.move\_iterator($backward$) and then 
	     returns $L$.current\_element($x$).  
}


\bigskip
{\bf 3.5 Operators}  


\operator {\mbox{$\mathit{list}\Lless \mathit{E}\Lgreater \&$}}
{\mbox{$\mathit{L}\ =\ \mathit{list}\ \mathit{L1}$}}  
{The assignment operator makes $L$ a copy of
	     list $L_1$. More precisely if $L_1$ is the sequence
	     of items $x_1, x_2, \dots , x_n$ then $L$ is made a
	     sequence of items $y_1, y_2, \dots , y_n$ with
	     $L[y_i] = L_1[x_i]$ for $1 \le i \le n$. 
}

\operator {\mbox{$\mathit{E}\&$}}
{\mbox{$\mathit{L}[\mathit{list\nspaceunderscore\_item}\ \mathit{it}]$}}  
{returns a reference to the contents of $it$. 
}


\bigskip
{\bf 3.6 Iterations Macros}

{\bf forall\_items}($it,L$)       
$\{$ ``the items of $L$ are successively assigned to $it$'' $\}$

{\bf forall}($x,L$)       
$\{$ ``the elements of $L$ are successively assigned to $x$'' $\}$  


\implementation

The data type list is realized by doubly linked linear lists. All operations
take constant time except for the following operations: search and rank take 
linear time $O(n)$, item($i$) takes time $O(i)$, bucket\_sort takes time 
$O(n + j - i)$ and sort takes time $O(n\cdot c\cdot\log n$) where $c$ is the 
time complexity of the compare function. $n$ is always the current length of 
the list. 


\end{manual}
