/*******************************************************************************
+
+  LEDA 3.5
+
+  basic.h
+
+  This file is part of the LEDA research version (LEDA-R) that can be 
+  used free of charge in academic research and teaching. Any commercial
+  use of this software requires a license which is distributed by the
+  LEDA Software GmbH, Postfach 151101, 66041 Saarbruecken, FRG
+  (fax +49 681 31104).
+
+  Copyright (c) 1991-1997  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 66123 Saarbruecken, Germany     
+  All rights reserved.
+ 
*******************************************************************************/
#ifndef LEDA_BASIC_H
#define LEDA_BASIC_H


#if !defined(LEDA_ROOT_INCL_ID)
#define LEDA_ROOT_INCL_ID 350017
#include <LEDA/REDEFINE_NAMES.h>
#endif

#include <iostream.h>
#include <stdlib.h>


// LEDA version macro

#define __LEDA__ 350


//turn checking off for installation

#if defined(LEDA_INSTALL)
#define LEDA_CHECKING_OFF
#endif


// include basic LEDA header files

#include <LEDA/system.h>
#include <LEDA/global.h>
#include <LEDA/bool.h>
#include <LEDA/error.h>
#include <LEDA/thread.h>
#include <LEDA/memory.h>
#include <LEDA/param_types.h>
#include <LEDA/handle_types.h>
#include <LEDA/string.h>
#include <LEDA/random.h>
#include <LEDA/iteration.h>
#include <LEDA/lin_order.h>
#include <LEDA/misc.h>

#if defined(min)
#undef min
#endif

#if defined(max)
#undef max
#endif


#if LEDA_ROOT_INCL_ID == 350017
#undef LEDA_ROOT_INCL_ID
#include <LEDA/UNDEFINE_NAMES.h>
#endif

#endif
