/*******************************************************************************
+
+  LEDA 3.5
+
+  bool.h
+
+  This file is part of the LEDA research version (LEDA-R) that can be 
+  used free of charge in academic research and teaching. Any commercial
+  use of this software requires a license which is distributed by the
+  LEDA Software GmbH, Postfach 151101, 66041 Saarbruecken, FRG
+  (fax +49 681 31104).
+
+  Copyright (c) 1991-1997  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 66123 Saarbruecken, Germany     
+  All rights reserved.
+ 
*******************************************************************************/
#ifndef LEDA_BOOL_H
#define LEDA_BOOL_H

#if !defined(LEDA_ROOT_INCL_ID)
#define LEDA_ROOT_INCL_ID 350020
#include <LEDA/REDEFINE_NAMES.h>
#endif

#if !defined(__HAS_BUILTIN_BOOL__)


/*{\Manpage {bool} {} {Boolean Values} }*/

/*{\Mdefinition
An instance of the data type $bool$ has either the value $true$ or $false$. 
The usual \CC logical operators \&\& (and), $||$ (or), ! (negation) are 
defined for $bool$. }*/

#if defined(_MSC_VER)
#pragma warning(disable: 4237)
#endif

typedef char bool;
enum {false=0, true=1};

#endif


#if LEDA_ROOT_INCL_ID == 350020
#undef LEDA_ROOT_INCL_ID
#include <LEDA/UNDEFINE_NAMES.h>
#endif

#endif
