/*******************************************************************************
+
+  LEDA 3.5
+
+  d3_window.h
+
+  This file is part of the LEDA research version (LEDA-R) that can be 
+  used free of charge in academic research and teaching. Any commercial
+  use of this software requires a license which is distributed by the
+  LEDA Software GmbH, Postfach 151101, 66041 Saarbruecken, FRG
+  (fax +49 681 31104).
+
+  Copyright (c) 1991-1997  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 66123 Saarbruecken, Germany     
+  All rights reserved.
+ 
*******************************************************************************/
#include <LEDA/graph.h>
#include <LEDA/vector.h>
#include <LEDA/d3_rat_point.h>
#include <LEDA/d3_point.h>
#include <LEDA/window.h>


class poly_anim {

typedef GRAPH<d3_rat_point,int> polyeder;
typedef GRAPH<d3_point,int> f_polyeder;

bool   grey_scales;
bool   draw_solid;
bool   elim;
bool   draw_edges;
double speed;
double rot1;
double rot2;
double zoom_f;
node_array<vector> pos1;


window*      Wp;
const graph* Hp;

public:

poly_anim(window& W, const polyeder& P);
poly_anim(window& W, const f_polyeder& P);

void init(window& W, const polyeder& P);
void init(window& W, const f_polyeder& P);

void draw();
int  move();
void zoom(double);

void set_speed(int s)  { speed = s; }
void set_elim(bool b)  { elim  = b; }
void set_solid(bool b) { draw_solid = b; }
void set_draw_edges(bool b) { draw_edges = b; }

};

