/*******************************************************************************
+
+  LEDA 3.5
+
+  menu.h
+
+  This file is part of the LEDA research version (LEDA-R) that can be 
+  used free of charge in academic research and teaching. Any commercial
+  use of this software requires a license which is distributed by the
+  LEDA Software GmbH, Postfach 151101, 66041 Saarbruecken, FRG
+  (fax +49 681 31104).
+
+  Copyright (c) 1991-1997  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 66123 Saarbruecken, Germany     
+  All rights reserved.
+ 
*******************************************************************************/
#ifndef LEDA_MENU_H 
#define LEDA_MENU_H

#if !defined(LEDA_ROOT_INCL_ID)
#define LEDA_ROOT_INCL_ID 350075
#include <LEDA/REDEFINE_NAMES.h>
#endif


#include <LEDA/window.h>

//------------------------------------------------------------------------------
//   MENUES
//------------------------------------------------------------------------------

/*{\Manpage {menu} {} {Menues}}*/

class menu : public window {

/*{\Mdefinition
Menues are special panels consisting only of a vertical list of buttons. }*/

public:

/*{\Mcreation M }*/

 menu() : window(-1,-1) { buttons_per_line(1); }
/*{\Mcreate creates an empty menu $M$.}*/

 menu(string s) : window(-1,-1,s) { buttons_per_line(1); }
/*{\Mcreate creates an empty menu $M$ with header $s$.}*/

~menu() {}


/*{\Moperations 1.2 4.8 }*/

void button(string s, int n) { window::button(s,n); }
/*{\Mopl     adds a button with label $s$ and number $n$ to $M$.}*/

void  button(string s) { window::button(s); }
/*{\Mopl     adds a new button to $M$ with label $s$ and number equal to its
             position in the list of all buttons (starting with $0$).}*/


void  button(string s, int n, void (*F)(int)) { window::button(s,n,F); }
/*{\Mopl     adds a button with label $s$, number $n$ and action 
             function $F$ to $M$. Function $F$ is called with actual
             parameter $n$  whenever the button is pressed. }*/

void  button(string s, void (*F)(int)) { window::button(s,F); }
/*{\Mopl     adds a button with label $s$, number equal to its rank and action 
             function $F$ to $M$. Function $F$ is called with the number of the
             button as argument whenever the button is pressed. }*/

void  button(string s, window& M) { window::button(s,M); }
/*{\Mopl     adds a button with label $s$ and attached window $M$ to $M$.
             Whenever the button is pressed the $M$ is opened and 
             $M$.read\_mouse() is returned. }*/


};


#if LEDA_ROOT_INCL_ID == 350075
#undef LEDA_ROOT_INCL_ID
#include <LEDA/UNDEFINE_NAMES.h>
#endif

#endif
