/*******************************************************************************
+
+  LEDA 3.5
+
+  node_map2.h
+
+  This file is part of the LEDA research version (LEDA-R) that can be 
+  used free of charge in academic research and teaching. Any commercial
+  use of this software requires a license which is distributed by the
+  LEDA Software GmbH, Postfach 151101, 66041 Saarbruecken, FRG
+  (fax +49 681 31104).
+
+  Copyright (c) 1991-1997  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 66123 Saarbruecken, Germany     
+  All rights reserved.
+ 
*******************************************************************************/
#ifndef LEDA_NODE_MAP2_H
#define LEDA_NODE_MAP2_H

#if !defined(LEDA_ROOT_INCL_ID)
#define LEDA_ROOT_INCL_ID 350081
#include <LEDA/REDEFINE_NAMES.h>
#endif


//------------------------------------------------------------------------------
// two-dimensional node maps
//
// S. Naeher (1997)
//------------------------------------------------------------------------------


/*{\Manpage {node_map2} {E} {Two-Dimensional Node Maps} }*/

#include <LEDA/graph.h>
#include <LEDA/map.h>

template <class E>
class node_map2 {

/*{\Mdefinition
An instance of the data type |\Mname| is a map2 for the pairs of nodes of a 
graph $G$, i.e., equivalent to $map2\<node,node,E\>$ (cf. \ref{Two-Dimensional 
Maps}). It can be used as a dynamic variant of the data type $node\_matrix$
(cf. \ref{Node Matrices}). }*/

  map<int,E>*  m;
  const graph* g;

  
public:

/*{\Mcreation M }*/

node_map2() { m = new map<int,E>; g  = nil; }
/*{\Mcreate  introduces a variable |\Mvar| of type |\Mname| and initializes
             it to the map2 with empty domain. }*/

node_map2(const graph& G) { m = new map<int,E>; g = &G; }
/*{\Mcreate  introduces a variable |\Mvar| of type |\Mname| and initializes
             it with a mapping $m$ from the set of all nodes of $G$ into 
             the set of variables of type $E$. The variables in the range 
             of $m$ are initialized by a call of the default constructor 
             of type $E$. }*/

node_map2(const graph& G, E x) { m = new map<int,E>(x); g = &G; }
/*{\Mcreate  introduces a variable |\Mvar| of type |\Mname| and initializes
             it with a mapping $m$ from the set of all nodes of $G$ into 
             the set of variables of type $E$. The variables in the range 
             of $m$ are initialized with a copy of $x$. }*/

~node_map2() { delete m; }


/*{\Moperations 1.3 4.3 }*/


void init()  { delete m; m = new map<int,E>; g = 0; }
/*{\Mop      makes |\Mvar| a node map2 with empty domain. }*/

void init(const graph& G)  { delete m; m = new map<int,E>; g = &G; } 
/*{\Mop       makes |\Mvar| to a mapping $m$ from the set of all nodes of $G$ 
              into the set of variables of type $E$. The variables in the 
              range of $m$ are initialized by a call of the default 
              constructor of type $E$. }*/

void init(const graph& G, E x) { delete m; m = new map<int,E>(x); g = &G; } 
/*{\Mop       makes |\Mvar| to a mapping $m$ from the set of all nodes of $G$ 
              into the set of variables of type $E$. The variables in the 
              range of $m$ are initialized with a copy of $x$. }*/

const E& operator()(node v, node w) const 
{  return  (*m)[((unsigned long)index(v)<<16) + (unsigned long)index(w)]; }

E& operator()(node v,node w)
{  return  (*m)[((unsigned long)index(v)<<16) + (unsigned long)index(w)]; }
/*{\Mfunop    returns the variable $M(v,w)$. }*/

bool defined(node v, node w) const
{ return m->defined(((unsigned long)index(v)<<16) + (unsigned long)index(w)); }
/*{\Mop    returns true if $(v,w) \in dom(m)$ and false otherwise. }*/

};

/*{\Mimplementation
Node maps are implemented by an efficient hashing method based on the 
internal numbering of the nodes. An access operation takes expected 
time $O(1)$. 
}*/



#if LEDA_ROOT_INCL_ID == 350081
#undef LEDA_ROOT_INCL_ID
#include <LEDA/UNDEFINE_NAMES.h>
#endif

#endif
