/*******************************************************************************
+
+  LEDA 3.5
+
+  _basic.c
+
+  This file is part of the LEDA research version (LEDA-R) that can be 
+  used free of charge in academic research and teaching. Any commercial
+  use of this software requires a license which is distributed by the
+  LEDA Software GmbH, Postfach 151101, 66041 Saarbruecken, FRG
+  (fax +49 681 31104).
+
+  Copyright (c) 1991-1997  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 66123 Saarbruecken, Germany     
+  All rights reserved.
+ 
*******************************************************************************/
#include <LEDA/basic.h>


void  wait(float sec)     { LEDA::sleep(sec); } 
float used_time()         { return LEDA::used_time(); }
float used_time(float& T) { return LEDA::used_time(T); }

void print_time() 
{ cout << string(" time = %.2f sec",LEDA::used_time()) << endl; }

void print_time(string s) 
{ cout << s; print_time(); }




int Yes(string s)
{ char answer = read_char(s);
  return ((answer == 'y') || (answer == 'Y'));
}

int read_int(string s)
{ int answer;
  char c;

  for(;;)
  { cout << s;
    cin >> answer;
    if (!cin) 
      { cin.clear();
        cin.get(c);
        cout << string("read_int: illegal input \"%c\"\n",c);
        if (c != '\n') skip_line(cin);
       }
    else  
       break;
   }

  skip_line(cin);

  return answer;
}

char read_char(string s)
{ char c;
  cout << s;
  cin.get(c);
  if (c != '\n') skip_line(cin);
  return c;
}

double read_real(string s)
{ double answer;
  cout << s;
  cin >> answer;
  skip_line(cin);
  return answer;
}

string read_line(istream& in)
{ string result;
  result.read_line(in); 
  return result;
 }

string read_string(string s)
{ cout << s << flush;
  return read_line(cin); 
 }

void skip_line(istream& s)
{ char c;
  while(s.get(c) &&  c != '\n');
 }

int     Yes()              { return Yes(""); }
int     read_int()         { return read_int(""); }
char    read_char()        { return read_char(""); }
double  read_real()        { return read_real(""); }
string  read_string()      { return read_string(""); } 

