/*******************************************************************************
+
+  LEDA 3.5
+
+  bitmaps.h
+
+  This file is part of the LEDA research version (LEDA-R) that can be 
+  used free of charge in academic research and teaching. Any commercial
+  use of this software requires a license which is distributed by the
+  LEDA Software GmbH, Postfach 151101, 66041 Saarbruecken, FRG
+  (fax +49 681 31104).
+
+  Copyright (c) 1991-1997  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 66123 Saarbruecken, Germany     
+  All rights reserved.
+ 
*******************************************************************************/

/****************************************************************************/
/*                    Bitmaps for edge-styles                                */
/****************************************************************************/

#define dashed_width 30
#define dashed_height 13
static char dashed_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x3c, 0x1e, 0x8f, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00};
#define dotted_width 30
#define dotted_height 13
static char dotted_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0xcc, 0xcc, 0xcc, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00};
#define solid_width 30
#define solid_height 13
static char solid_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0xfc, 0xff, 0xff, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00};


/****************************************************************************/
/*                    Bitmaps for label-position                            */
/****************************************************************************/

#define c_width 19
#define c_height 19
static char c_bits[] = {
 0x40,0x10,0x00,0x40,0x10,0x00,0x40,0x10,0x00,0x40,0x10,0x00,0x40,0x10,0x00,
 0x40,0x10,0x00,0xff,0xff,0x07,0xc0,0x1f,0x00,0xc0,0x1f,0x00,0xc0,0x1f,0x00,
 0xc0,0x1f,0x00,0xc0,0x1f,0x00,0xff,0xff,0x07,0x40,0x10,0x00,0x40,0x10,0x00,
 0x40,0x10,0x00,0x40,0x10,0x00,0x40,0x10,0x00,0x40,0x10,0x00};
#define l_width 19
#define l_height 19
static char l_bits[] = {
 0x40,0x10,0x00,0x40,0x10,0x00,0x40,0x10,0x00,0x40,0x10,0x00,0x40,0x10,0x00,
 0x40,0x10,0x00,0xff,0xff,0x07,0x7f,0x10,0x00,0x7f,0x10,0x00,0x7f,0x10,0x00,
 0x7f,0x10,0x00,0x7f,0x10,0x00,0xff,0xff,0x07,0x40,0x10,0x00,0x40,0x10,0x00,
 0x40,0x10,0x00,0x40,0x10,0x00,0x40,0x10,0x00,0x40,0x10,0x00};
#define o_width 19
#define o_height 19
static char o_bits[] = {
 0xc0,0x1f,0x00,0xc0,0x1f,0x00,0xc0,0x1f,0x00,0xc0,0x1f,0x00,0xc0,0x1f,0x00,
 0xc0,0x1f,0x00,0xff,0xff,0x07,0x40,0x10,0x00,0x40,0x10,0x00,0x40,0x10,0x00,
 0x40,0x10,0x00,0x40,0x10,0x00,0xff,0xff,0x07,0x40,0x10,0x00,0x40,0x10,0x00,
 0x40,0x10,0x00,0x40,0x10,0x00,0x40,0x10,0x00,0x40,0x10,0x00};
#define r_width 19
#define r_height 19
static char r_bits[] = {
 0x40,0x10,0x00,0x40,0x10,0x00,0x40,0x10,0x00,0x40,0x10,0x00,0x40,0x10,0x00,
 0x40,0x10,0x00,0xff,0xff,0x07,0x40,0xf0,0x07,0x40,0xf0,0x07,0x40,0xf0,0x07,
 0x40,0xf0,0x07,0x40,0xf0,0x07,0xff,0xff,0x07,0x40,0x10,0x00,0x40,0x10,0x00,
 0x40,0x10,0x00,0x40,0x10,0x00,0x40,0x10,0x00,0x40,0x10,0x00};
#define u_width 19
#define u_height 19
static char u_bits[] = {
 0x40,0x10,0x00,0x40,0x10,0x00,0x40,0x10,0x00,0x40,0x10,0x00,0x40,0x10,0x00,
 0x40,0x10,0x00,0xff,0xff,0x07,0x40,0x10,0x00,0x40,0x10,0x00,0x40,0x10,0x00,
 0x40,0x10,0x00,0x40,0x10,0x00,0xff,0xff,0x07,0xc0,0x1f,0x00,0xc0,0x1f,0x00,
 0xc0,0x1f,0x00,0xc0,0x1f,0x00,0xc0,0x1f,0x00,0xc0,0x1f,0x00};
#define lo_width 19
#define lo_height 19
static char lo_bits[] = {
 0x7f,0x10,0x00,0x7f,0x10,0x00,0x7f,0x10,0x00,0x7f,0x10,0x00,0x7f,0x10,0x00,
 0x7f,0x10,0x00,0xff,0xff,0x07,0x40,0x10,0x00,0x40,0x10,0x00,0x40,0x10,0x00,
 0x40,0x10,0x00,0x40,0x10,0x00,0xff,0xff,0x07,0x40,0x10,0x00,0x40,0x10,0x00,
 0x40,0x10,0x00,0x40,0x10,0x00,0x40,0x10,0x00,0x40,0x10,0x00};
#define lu_width 19
#define lu_height 19
static char lu_bits[] = {
 0x40,0x10,0x00,0x40,0x10,0x00,0x40,0x10,0x00,0x40,0x10,0x00,0x40,0x10,0x00,
 0x40,0x10,0x00,0xff,0xff,0x07,0x40,0x10,0x00,0x40,0x10,0x00,0x40,0x10,0x00,
 0x40,0x10,0x00,0x40,0x10,0x00,0xff,0xff,0x07,0x7f,0x10,0x00,0x7f,0x10,0x00,
 0x7f,0x10,0x00,0x7f,0x10,0x00,0x7f,0x10,0x00,0x7f,0x10,0x00};
#define ro_width 19
#define ro_height 19
static char ro_bits[] = {
 0x40,0xf0,0x07,0x40,0xf0,0x07,0x40,0xf0,0x07,0x40,0xf0,0x07,0x40,0xf0,0x07,
 0x40,0xf0,0x07,0xff,0xff,0x07,0x40,0x10,0x00,0x40,0x10,0x00,0x40,0x10,0x00,
 0x40,0x10,0x00,0x40,0x10,0x00,0xff,0xff,0x07,0x40,0x10,0x00,0x40,0x10,0x00,
 0x40,0x10,0x00,0x40,0x10,0x00,0x40,0x10,0x00,0x40,0x10,0x00};
#define ru_width 19
#define ru_height 19
static char ru_bits[] = {
 0x40,0x10,0x00,0x40,0x10,0x00,0x40,0x10,0x00,0x40,0x10,0x00,0x40,0x10,0x00,
 0x40,0x10,0x00,0xff,0xff,0x07,0x40,0x10,0x00,0x40,0x10,0x00,0x40,0x10,0x00,
 0x40,0x10,0x00,0x40,0x10,0x00,0xff,0xff,0x07,0x40,0xf0,0x07,0x40,0xf0,0x07,
 0x40,0xf0,0x07,0x40,0xf0,0x07,0x40,0xf0,0x07,0x40,0xf0,0x07};


/****************************************************************************/
/*                    Bitmaps for node-shapes                               */
/****************************************************************************/

#define circle_width 41
#define circle_height 15
static char circle_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x83, 0x01, 0x00, 0x00, 0x00, 0x80, 0x00, 0x02, 0x00, 0x00,
   0x00, 0x80, 0x00, 0x02, 0x00, 0x00, 0x00, 0x40, 0x00, 0x04, 0x00, 0x00,
   0x00, 0x40, 0x00, 0x04, 0x00, 0x00, 0x00, 0x40, 0x00, 0x04, 0x00, 0x00,
   0x00, 0x40, 0x00, 0x04, 0x00, 0x00, 0x00, 0x40, 0x00, 0x04, 0x00, 0x00,
   0x00, 0x80, 0x00, 0x02, 0x00, 0x00, 0x00, 0x80, 0x00, 0x02, 0x00, 0x00,
   0x00, 0x00, 0x83, 0x01, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define ellipse_width 41
#define ellipse_height 15
static char ellipse_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xff, 0x03, 0x00, 0x00,
   0x00, 0x78, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x06, 0x00, 0xc0, 0x00, 0x00,
   0x00, 0x01, 0x00, 0x00, 0x01, 0x00, 0x80, 0x00, 0x00, 0x00, 0x02, 0x00,
   0x40, 0x00, 0x00, 0x00, 0x04, 0x00, 0x40, 0x00, 0x00, 0x00, 0x04, 0x00,
   0x40, 0x00, 0x00, 0x00, 0x04, 0x00, 0x80, 0x00, 0x00, 0x00, 0x02, 0x00,
   0x00, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x06, 0x00, 0xc0, 0x00, 0x00,
   0x00, 0x78, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x80, 0xff, 0x03, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define rectangle_width 41
#define rectangle_height 15
static char rectangle_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xff, 0xff, 0xff, 0x07, 0x00,
   0x40, 0x00, 0x00, 0x00, 0x04, 0x00, 0x40, 0x00, 0x00, 0x00, 0x04, 0x00,
   0x40, 0x00, 0x00, 0x00, 0x04, 0x00, 0x40, 0x00, 0x00, 0x00, 0x04, 0x00,
   0x40, 0x00, 0x00, 0x00, 0x04, 0x00, 0x40, 0x00, 0x00, 0x00, 0x04, 0x00,
   0x40, 0x00, 0x00, 0x00, 0x04, 0x00, 0x40, 0x00, 0x00, 0x00, 0x04, 0x00,
   0x40, 0x00, 0x00, 0x00, 0x04, 0x00, 0x40, 0x00, 0x00, 0x00, 0x04, 0x00,
   0x40, 0x00, 0x00, 0x00, 0x04, 0x00, 0xc0, 0xff, 0xff, 0xff, 0x07, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define square_width 41
#define square_height 15
static char square_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xff, 0x07, 0x00, 0x00,
   0x00, 0x40, 0x00, 0x04, 0x00, 0x00, 0x00, 0x40, 0x00, 0x04, 0x00, 0x00,
   0x00, 0x40, 0x00, 0x04, 0x00, 0x00, 0x00, 0x40, 0x00, 0x04, 0x00, 0x00,
   0x00, 0x40, 0x00, 0x04, 0x00, 0x00, 0x00, 0x40, 0x00, 0x04, 0x00, 0x00,
   0x00, 0x40, 0x00, 0x04, 0x00, 0x00, 0x00, 0x40, 0x00, 0x04, 0x00, 0x00,
   0x00, 0x40, 0x00, 0x04, 0x00, 0x00, 0x00, 0x40, 0x00, 0x04, 0x00, 0x00,
   0x00, 0x40, 0x00, 0x04, 0x00, 0x00, 0x00, 0xc0, 0xff, 0x07, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00};


/****************************************************************************/
/*                    Bitmaps for edge-labels                               */
/****************************************************************************/

#define clab_width 19
#define clab_height 19
static char clab_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x00, 0x00, 0xe0, 0x00,
   0x00, 0xe0, 0x00, 0x00, 0xb0, 0x00, 0x00, 0x18, 0x00, 0x10, 0x3f, 0x00,
   0x10, 0x55, 0x00, 0x10, 0x77, 0x00, 0x90, 0x55, 0x00, 0xf0, 0x35, 0x00,
   0x60, 0x00, 0x00, 0x30, 0x00, 0x00, 0x18, 0x00, 0x00, 0x0c, 0x00, 0x00,
   0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define llab_width 19
#define llab_height 19
static char llab_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x03,
   0xe2, 0x86, 0x03, 0xa2, 0x8a, 0x03, 0xe2, 0xce, 0x02, 0xa2, 0x6a, 0x02,
   0xae, 0x36, 0x00, 0x00, 0x18, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x06, 0x00,
   0x00, 0x03, 0x00, 0x80, 0x01, 0x00, 0xc0, 0x00, 0x00, 0x40, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define rlab_width 19
#define rlab_height 19
static char rlab_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x00,
   0x00, 0x1c, 0x00, 0x00, 0x1c, 0x00, 0x00, 0x16, 0x00, 0x00, 0x13, 0x00,
   0x80, 0x01, 0x00, 0xc0, 0x00, 0x00, 0x60, 0x00, 0x00, 0xb0, 0x90, 0x01,
   0x98, 0xa8, 0x02, 0x8c, 0xb8, 0x03, 0x86, 0xa8, 0x02, 0x82, 0xab, 0x01,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
