/*******************************************************************************
+
+  LEDA 3.5
+
+  help.c
+
+  This file is part of the LEDA research version (LEDA-R) that can be 
+  used free of charge in academic research and teaching. Any commercial
+  use of this software requires a license which is distributed by the
+  LEDA Software GmbH, Postfach 151101, 66041 Saarbruecken, FRG
+  (fax +49 681 31104).
+
+  Copyright (c) 1991-1997  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 66123 Saarbruecken, Germany     
+  All rights reserved.
+ 
*******************************************************************************/
#include <LEDA/graphwin.h>

void GraphWin::help_news()
{ window& W = get_window();
  panel P;
  P.set_panel_bg_color(ivory);
  P.text_item("\\bf New in Version 1.0");
  P.text_item("");
  P.button("ok");
  W.disable_panel();
  P.open(W);
  W.enable_panel();
}



void GraphWin::help_about()
{
  window& W = get_window();

panel P;

P.set_panel_bg_color(ivory);

P.text_item("\\bf GraphWin (Version 1.0)");
P.text_item("");
P.text_item("");
P.text_item("by D. Alberts, A. Luleich, and S.Naeher (1997)");
P.text_item("");
P.text_item("");
P.text_item("");
P.text_item("\
GraphWin is a LEDA data type for constructing, displaying \
and manipulating graphs and for animating and debugging graph \
algorithms. Please see the LEDA User Manual for a detailed description.");
P.text_item("");
P.text_item("");
P.text_item("\
The design and implementation of Version 1.0 was \
supported in part by DFG-Grant Na303/1-2, Effiziente Algorithmen \
fuer diskrete Probleme und ihre Anwendungen. ");
P.text_item("");

P.button("ok");
W.disable_panel();
P.open(W);
W.enable_panel();
}


void GraphWin::help_mouse_left()
{

window& W = get_window();
char* txt;
panel P;

P.set_panel_bg_color(ivory);

P.text_item("\\bf Left Mouse Button  (Create & Move)");
txt = "\
The left button is used for creating and moving objects.";
P.text_item("");
P.text_item(txt);
txt = "\
A single click on the window background creates a new node. \
A single click on a node selects this node as the source of a new edge. \
The next click defines the target of the edge which is either an existing \
node or a new node (if clicked on the window background). Before defining \
the target node, bends may be introduced using the middle  button. \
The creation of the new edge can be canceled by clicking the right button.";  
P.text_item("");
P.text_item(txt);
txt = "\
Holding down and dragging the left button moves the object under the \
mouse pointer or the window background. \
If a SHIFT key is pressed simultaneously the connected component of the \
corresponding object is moved or a zoom window is opened, respectively.";
P.text_item("");
P.text_item(txt);

txt = "\
Double clicking on a node or edge opens a dialog box for setting \
or changing the paramaters of the corresponding object.";
P.text_item("");
P.text_item(txt);

P.button("ok");

  W.disable_panel();
  P.open(W);
  W.enable_panel();

}



void GraphWin::help_mouse_middle()
{

window& W = get_window();
char* txt;
panel P;

P.set_panel_bg_color(ivory);


P.text_item("\\bf Middle Mouse Button   (Select)");
P.text_item("");
txt = "\
The middle button is used for selecting or deselecting nodes and edges.    \
A single click includes (removes) the object under the mouse cursor        \
into (from) the current selection. If a SHIFT key is pressed simultaneously \
the connected component of the corresponding object is selected or unselected. \
By clicking on the window background,   \
holding down the button, and dragging the mouse a rectangular area is      \
defined. After releasing the button all objects contained in this area are \
selected or unselected. \
A single (double) click on the window background unselects (selects) all   \
nodes of the graph.";
P.text_item(txt);
P.text_item("");
txt = "\
On two-button systems the middle button can be emulated by holding down  \
the ALT key and pressing any button";
P.text_item(txt);
P.text_item("");

P.button("ok");

  W.disable_panel();
  P.open(W);
  W.enable_panel();
}


void GraphWin::help_mouse_right()
{

window& W = get_window();
char* txt;
panel P;

P.set_panel_bg_color(ivory);


P.text_item("\\bf Right Mouse Button   (Delete & Cancel)");
P.text_item("");
txt = "\
The right button is used for deleting objects. A single click on a node   \
or edge deletes the corresponding object. If a SHIFT key is pressed \
simultaneously the connected component of the corresponding object \
is deleted.";
P.text_item(txt);
P.text_item("");

P.button("ok");

  W.disable_panel();
  P.open(W);
  W.enable_panel();
}

