/*******************************************************************************
+
+  LEDA 3.5
+
+  _integer_vector.c
+
+  This file is part of the LEDA research version (LEDA-R) that can be 
+  used free of charge in academic research and teaching. Any commercial
+  use of this software requires a license which is distributed by the
+  LEDA Software GmbH, Postfach 151101, 66041 Saarbruecken, FRG
+  (fax +49 681 31104).
+
+  Copyright (c) 1991-1997  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 66123 Saarbruecken, Germany     
+  All rights reserved.
+ 
*******************************************************************************/
//---------------------------------------------------------------------
// file generated by notangle from integer_vector.lw
// please debug or modify LEDA web file
// mails and bugs: leda@mpi-sb.mpg.de
// based on LEDA architecture by S. Naeher, C. Uhrig
// coding: K. Mehlhorn, M. Seel
//---------------------------------------------------------------------


#include <LEDA/integer_vector.h>



integer_vector::integer_vector(int n) 
{ 
  LEDA_PRECOND((n >= 0), "integer_vector::constructor: \
  negative dimension.") 
  d = n; 
  v = (RTINT*)nil;
  if (d > 0)
  { 
    allocate_vec_space(v,d);
    while (n--) v[n] = RTINT(0);
  }
}


integer_vector::
integer_vector(const RTINT& x, const RTINT& y) 
{ 
  d = 2;
  allocate_vec_space(v,d);
  v[0] = x;
  v[1] = y;
}


integer_vector::
integer_vector(const RTINT& x, const RTINT& y, const RTINT& z) 
{ 
  d = 3;
  allocate_vec_space(v,d);
  v[0] = x;
  v[1] = y;
  v[2] = z;
}


integer_vector::
integer_vector(const RTINT& x, const RTINT& y, const RTINT& z, 
        const RTINT& the_real_last) 
{ 
  d = 4;
  allocate_vec_space(v,d);
  v[0] = x;
  v[1] = y;
  v[2] = z;
  v[3] = the_real_last;
}

integer_vector::
integer_vector(const integer_vector& p) 
{ 
  d = p.d;
  if (d > 0)
    allocate_vec_space(v,d);
  else
    v = (RTINT*)nil;

  for(int i=0; i<d; i++) 
    v[i] = p.v[i];  
}



integer_vector& integer_vector::
operator=(const integer_vector& vec)
{ 
  register int n = vec.d;
  if (n != d)
  { 
    if (d > 0)
      deallocate_vec_space(v,d);
    d=n;
  }
  if (n > 0)
    allocate_vec_space(v,n);
  else
    v = (RTINT*)nil;

  while (n--) v[n] = vec.v[n];
  return *this;
}


integer_vector& integer_vector::
operator+=(const integer_vector& vec)
{ 
  check_dimensions(vec);
  register int n = d;
  while (n--) v[n] += vec.v[n];
  return *this;
}

integer_vector& integer_vector::
operator-=(const integer_vector& vec)
{ 
  check_dimensions(vec);
  register int n = d;
  while (n--) v[n] -= vec.v[n];
  return *this;
}

integer_vector integer_vector::
operator+(const integer_vector& vec) const
{ 
  check_dimensions(vec);
  register int n = d;
  integer_vector result(n);
  while (n--) result.v[n] = v[n]+vec.v[n];
  return result;
}

integer_vector integer_vector::
operator-(const integer_vector& vec) const
{ 
  check_dimensions(vec);
  register int n = d;
  integer_vector result(n);
  while (n--) result.v[n] = v[n]-vec.v[n];
  return result;
}

integer_vector integer_vector::
operator-() const  // unary minus
{ 
  register int n = d;
  integer_vector result(n);
  while (n--) result.v[n] = -v[n];
  return result;
}


integer_vector integer_vector::
compmul(const RTINT& x) const
{ 
  int n = d;
  integer_vector result(n);
  while (n--) result.v[n] = v[n] * x;
  return result;
}


RTINT integer_vector::
operator*(const integer_vector& vec) const
{ 
  check_dimensions(vec);
  RTINT result=0;
  register int n = d;
  while (n--) result = result+v[n]*vec.v[n];
  return result;
}


bool integer_vector::
operator==(const integer_vector& vec)  const
{ 
  if (vec.d != d) return false;
  int i = 0;
  while ((i<d) && (v[i]==vec.v[i])) i++;
  return (i==d);
}



ostream&   operator<<(ostream& O, const integer_vector& v)
{
  /* syntax: d x_0 x_1 ... x_d-1 */
  O << v.d << ' '; 
  for (register int i = 0; i < v.d; i++)
    O << v[i] << ' ';
  return O;
}

istream&   operator>>(istream& in, integer_vector& v)
{ 
  /* syntax: d x_0 x_1 ... x_d-1 */
  int dim = 0;
  in >> dim;
  if (v.d != dim)
    v = integer_vector(dim);
  
  int i=0; 
  while (i < v.d && in >> v[i++]);
  return in;
}


int integer_vector::
cmp(const integer_vector& v1, const integer_vector& v2)
{ 
  register int i;
  v1.check_dimensions(v2);
  for(i=0; i < v1.dim() && v1[i]==v2[i]; i++);
  if (i == v1.dim()) return 0;
  return (v1[i] < v2[i]) ?  -1 : 1;
}




