/*******************************************************************************
+
+  LEDA 3.5
+
+  _dos_emx.c
+
+  This file is part of the LEDA research version (LEDA-R) that can be 
+  used free of charge in academic research and teaching. Any commercial
+  use of this software requires a license which is distributed by the
+  LEDA Software GmbH, Postfach 151101, 66041 Saarbruecken, FRG
+  (fax +49 681 31104).
+
+  Copyright (c) 1991-1997  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 66123 Saarbruecken, Germany     
+  All rights reserved.
+ 
*******************************************************************************/
#include <stdio.h>
#include <jmgraph.h>

/*
void  init_graphics(int mode, int& width, int& height, int& depth);
void  define_color(int i, int r, int g, int b);
void  draw_scan_segment(unsigned char* p, int x, int y, int len);
void  draw_pixel(int x, int y, unsigned char c);
int   check_next_event(int& val, int& x, int& y, int block);
*/


void init_graphics(int mode, int& width, int& height, int& depth)
{
  if (mode == 1) // graphics mode
  { 
     if (!g_mode(G640x480x16))
     { fprintf (stderr, "Cannot switch to graphics mode 640x480x16\n");
       exit(1);
      }

     g_clip(0,0,g_xsize-1,g_ysize-1);

     width  = g_xsize;
     height = g_ysize;
     depth  = 4;
    }
  else
    g_mode(GTEXT);

}


void define_color(int index, int red, int green, int blue)
{ char pal[3];
  pal[0] = red/4;
  pal[1] = green/4;
  pal[2] = blue/4;
  g_vgapal(pal,index,1,1);
}

void draw_pixel(int x, int y, unsigned char c)   
{ g_set(x,y,c); }

void  draw_scan_segment(unsigned char* p, int x, int y, int len)
{ while (len--) g_set(x++,y,*p++); }

int   check_next_event(int& val, int& x, int& y, int block)
{ return 0; }

