/* pattern_test.cc */

#include "pattern_match.h"
#include <stdio.h>
#include <ctype.h>

bool get_string( const string &line, int &pos, string &s ) {
  int len = line.length();
  /* eat whitespace */
  while( pos < len && isspace( line[pos] ) ) pos++;
  /* scan to end of string */
  int end_pos = pos;
  while( end_pos < len && !isspace( line[end_pos] ) ) end_pos++;
  if( pos < len ) {
    s = line( pos, end_pos - 1 );
    pos = end_pos; 
    return false;
  }
  return true;
}

int main( void ) {
  string line;
  cout << "<pattern> ... <string> <newline>\n\n";
  while( 1 ) {
    cout << "> ";
    line.read_line();
    if( !line.length() ) exit(1);
    
    if( line == "quit" || line == "q" || line == "exit" ) break;

    int pos = 0;
    string pattern;
    if( get_string( line, pos, pattern ) ) continue;
    string s;
    while( !get_string( line, pos, s ) ) {
      if( pattern_match( s, pattern ) ) {
	cout << "\"" << s << "\" MATCHES PATTERN \"" << pattern << "\"\n";
      } else {
	cout << "\"" << s << "\" DOES NOT MATCH PATTERN \""
	     << pattern << "\"\n";
      }
    }
    cout << "\n";
  }
  return 0;
}
