#include <coriolis/kernel.h>
#include <iostream.h>
#include "junk.h"
#include "simple3d.h"
#include "common.h"

#ifndef BODY_DEF__H
#define BODY_DEF__H

const triple x_axis = triple( 1, 0, 0 );
const triple y_axis = triple( 0, 1, 0 );
const triple z_axis = triple( 0, 0, 1 );

/* defines a cyclinder with radius r and npts per circular face.
   axis'th( 0 = x, 1 = y, 2 = z ) axis is normal to circular faces */
MultiShape *define_cylinder( double radius, double height,
			     int npts = 12, triple center = 0, int axis = 2 );

MultiShape *define_cube( double xdim, double ydim, double zdim, 
			 triple center = 0 );

/* fills a vertex list with an n-sided approx of a circle centered at offset 
   in plan perpendicular to axis'th axis
   allocates space if *vertex is NULL */
void define_circle( triple **vertex, triple offset, double radius, 
		   int num_circ_pts = 12, int axis = 2 );

/* copies a list of num_points vertices adding offset. */
void copy_vertices( triple *destination, triple *source, int num_points, 
		   triple offset = 0 );

/* load a shape, scaling by the three values given along x, y, z */
Shape *load_shape( cstring, double, double, double, cstring name = "" );
Shape *load_shape( istream &, double, double, double, cstring name = "" );

MultiShape *def_shape( Polyhedron *p_array, int nphdrons = 1,
		       boolean allocate_poly3ds = FALSE );

#endif
