/* buf_info.h */

/* includes file position and parsing info so that
   descriptions of elements and components 
       parsed from a file can be located and replaced within that file.  
   descriptions of elements and components 
       created in ide can be located and changed in an internal buffer

   each buf_info block includes the following info
   filename - file or buffer name.
   pos - character position in file
   char_pos - absolute character position of first character of object 
              description from start of file.  position of start of file is 1
   len  - number of characters in description.  char_pos + len should be the 
   tag prev - tag of object whose definition starts directly before this
              one starts, or tag_error if this is first in file
   tag next - tag of object whose definition starts after this ones definition,
              or tag_error if this is last in file
   
   buffer naming convention -- suggest all internal buffer names start and end
       with * since * is an invalid character in afs filenames
   */

#ifndef BUF_INFO__H
#define BUF_INFO__H

#include <LEDA/basic.h>
#include "tag.h"
#include <iostream.h>

struct buf_info {
  string filename;
  int char_pos, len;
  tag prev_tag, next_tag;
    
  buf_info( void );
  buf_info( const string &FileName, int Char_Pos, int Len, tag Prev, tag Next );

  void set( const string &FileName, int Char_Pos, int Len, tag Prev, tag Next );

  string to_string( void ) const;
};

ostream &operator<<( ostream &, const buf_info & );

#endif
