/* distrib.h */

#ifndef DISTRIB__H
#define DISTRIB__H

#include "real.h"

class dc_distrib : public dc_real {
protected:
  /* inherited val treated as mean */

  double StdDev;
  double Min;
  double Max;
  bool bounds_absolute; /* if false then min = mean -3S, max = mean + 3s
			   otherwise, min and max are absolute boundries */
public: 
  dc_distrib( void );
  dc_distrib( const double nMean, const double nMin, const double nMax );
  dc_distrib( const double nMean, const double nStdDev );
  
  /* inherited functions */
  const dc_type sub_type( void ) const { return Distrib_t; }
  string type_string( void ) const { return string( "distrib" ); }
  
  /* input, output, and assignment operators */
  dc_distrib &operator=( dc_data &D );

  ostream &display( ostream &stream = cout ){ return display_c( stream ); }
  ostream &display_c( ostream &stream = cout ) const;
  friend ostream &operator<<( ostream &stream, const dc_distrib &D ) {
    return D.display_c( stream ); 
  }
  friend istream &operator>>( istream &stream, dc_distrib &D );
  
  /* functions to access Col/Row */
  void set( const double nMean, const double nStdDev );
  void set( double nMean, double nMin, double nMax );

  double get_mean( void ) const { return val; }
  double get_min( void ) const { return Min; }
  double get_max( void ) const { return Max; }
  double get_stddev( void ) const { return StdDev; }
  double get_sample( void ) const;
  bool get_bounds_abs( void ) const { return bounds_absolute; }

  dc_data *duplicate( void ) const;
};

#endif
