/* int.cc */

#include "integer.h"
#include "real.h"

dc_int::dc_int( const long int I = 0 ) {
  val = I;
  valid = true;
}

dc_int::dc_int( const long int I, const string &label, dc_node *parent = nil ) {
  val = I;
  set_both( label, parent );
}

dc_int &dc_int::operator=( const long int d ) {
  val = d;
  return *this;
}

dc_int &dc_int::operator=( dc_data &D ) {
  if( D.type() == Int_t ) {
    val = ( ( dc_int * ) &D )->val;
    units = ( ( dc_int * ) &D )->get_units();
  } else if( D.type() == Real_t ) {
    val = ( long int )( ( dc_real * ) &D )->get();
    units = ( ( dc_real * ) &D )->get_units();
  } else {
    cerr << "dc_int::operator= -- cannot assign " << D.type_string() 
	 << " to " << type_string() << "\n";
  }
  if( D.is_temporary() ) delete( &D );
  return *this;
} 

ostream &dc_int::display_c( ostream &stream = cout ) const {
  stream << val << units;
  return stream;
}

dc_label *dc_int::duplicate( dc_node *parent ) const {
  dc_int *dupe = new dc_int( val );
  dupe->set_units( get_units_c() );

  if( !is_temporary() ) {
    if( dupe->set_both( local_label(), parent ) ) {
      delete( dupe );
      return nil;
    }
  }
  dupe->set_visible( is_visible() );
  return ( dc_label * )dupe;
}

istream &operator>>( istream &stream, dc_int &I ) {
  stream >> I.val;
  return stream;
}
