/* Component.h */
#ifndef COMPONENT_CLASS
#define COMPONENT_CLASS

#include <LEDA/basic.h>
#include <LEDA/d_array.h>
#include <LEDA/h_array.h>
#include <generic.h>

/* The responsibility of ensuring that the progenitor is only destructed after
   its dynasty is destroyed; else the dynasty is like chickens with heads cut
   off */

class Component {
 private:
  IDLabel *ID;
  IDLabel *IDdBase;

 /* Q?: i am Assuming that the constructors of members are called before class */
     
  bool dBaseComponent; /* True if i am part of the database and have no
			  physical meaning */
  
  /* Pointer to component state, holds data relevant to elements,
     note that this allows quick, component level access to the state
     of various elements */
  GenArray state;

/* Q?: Code relevant to the state needs to be added for component to work */
/* The size of the state is constant over efficient copies & duplicate
   copies (unsure of duplicate) */
/* The size however changes when messing with addAnything not in context
   to a copy or duplicate */

  /* looks like hash tables will have to be duplicated as pointers
     are different for different temporal instantiations */

  /* Can there be elements for sub-system type components */
  /* The array indices start from 1, as 0 may indicate default emptiness */
  /* Q?: Why do i need the numbers nElements, etc; get rid if not needed */

  static seq_item tempItem; /* static will work only in a single processor appl*/
  
  /* used by duplicate */
  Component(const IDLabel &ID, const IDLabel &IDdBase, 
	    bool dBaseComponent);

 public:

  /* For new robot components */
  Component(const string &localLabel, const &Component dBaseComponent);
  
  /* For DBase components */
  Component(const string &dBaseLocal, const string &dBaseParent);

  Component();
  ~Component(void); 

  /* Q?: Are these appropriate as public components */
  AtomList<ElementPtr> elements;
  AtomList<ConstraintPtr> constraints;
  AtomList<ComponentPtr> components;

  Component& operator=(const Component &component); 
  /* efficient copy, does not copy structures that are constant temporally*/


  Component *duplicate(Component *componentptr);
  /* creates a complete copy including underlying structures  and
     children, useful for making copies of subsystems */
  
  Component *createChild(const string &localLabel, const Component 
			&dBaseTemplate, const Component &parent);
  /* Creates an empty child patterned after the dBase template and
     with appropriate entires in the hash tables of the parent  */
     

  /* use this only to create a child clone of mine */
  Component *createDBaseChild(const string &dBaseLocal,const Component &parent);
  /* Duplicates me, the parent with appropriate ID transfer, and 
     appropriate changes to me to point to the child */

  /* All the three below return a pointer to the atom's location */
  /* overloaded operator */
  GenPtr inline accessAtom(const int &atomIndex) {return(state.ptr[atomIndex])}

  GenPtr accessAtom(const string &atomId);
  GenPtr getIndex (const string &atomId, ComponentPtr *cPtr);

}
#endif /* COMPONENT_CLASS */

