/* ID.h */

#ifndef ID_CLASS
#define ID_CLASS

#include <LEDA/basic.h>
#include <SYNERGY/generic.h>

/* Q?: There are ID... functions in generic.h which are supposed to
   be used by other functions. If these only manipulate IDs, they
   should be brought in here and added as class functions */

/* The string operations in this class are not supposed to be efficient
   and hence be careful in intensive usage -> no of calls/second,... */

class IDLabel {
 private:
  string localLabel; /* local label allows me to be identified by my parent*/
                     /* Local label is derived from my fullLabel */
  bool localID;  /* true if this is used only to differentiate from siblings
		    in a tree, not for global identification,
		    in such a case, fullLabel is empty & irrelevant */
  IDLabel *parentID; /* Parent has to be assigned if !localID */
 public:
  IDLabel(string localLabel="", IDLabel *parentID=nil );
  IDLabel(const IDLabel &ID);
  ~IDLabel(void);

  IDLabel& operator=(const IDLabel &ID);

  void display(void);
  string label(void); /* returns localLabel if localID, full otherwise */
  bool itIs(string label); /* checks local if localID, full otherwise */
  IDLabel *parent() {return parentID;};
  friend ostream& operator<<(ostream& os, IDLabel &ID);
};

#endif /* ID_CLASS */
