
#ifndef GENERIC_INCL
#define GENERIC_INCL

#include<LEDA/basic.h>

const int WARN = 0;

inline void ERROR(int n, string errorString)
{
  cout << "\nERROR******" << n << ":" << errorString << "******\n";
  if (n > 0) exit (n);
}

/* bool is LEDA = true or false, normal logical operators defined */

/* The following inlines help string manipulation for ID string processing
   and accessing atoms & such; assumed structure of:
   any label /blah/blah/.../blah 
   any child or head  blah without any / in it
   / defined as DOT below */

const string DOT = ".";

inline string IDaddChild (const string &parentLabel, const string &child)
{ return  (parentLabel+DOT+child);}

inline string IDgetHead (const string &label)
{ return (label.head(label.pos(DOT,1))).replace(0,"");}

inline string IDgetTail (const string &label)
{ return label.del(0,label.pos(DOT,1)-1);}

/* returns true if label contains more than one DOT */
inline bool IDisLabel (const string &label)
{ return (label.pos(DOT,1) >= 0);}

inline string IDstripSlash (const string label)
{ return label.del(0);}

#endif 
