/* modification.h */

#ifndef MODIFICATION__H
#define MODIFICATION__H

#include "id.h"
#include "user_types.h"
#include "component.h"

/* modifications are invisible. any children must be dormant */

class dc_modification : public dc_component {
private:
  string hash_path;
  
  /* replacement for components template string */
  string replacement_template;

  list_item mod_list_ptr;

  bool done;
protected:
  void child_init( dc_label *child );

public:
  dc_modification( cstring hpath, dc_node *sorigin );
  ~dc_modification( void );

  const dc_type sub_type( void ) const { return Modification_t; }

  void set_path( cstring hpath ) { hash_path = hpath; }
  
  void clear_mods( void ); /* kills all children */
  
  bool set_type( const user_type u, bool inh )
    { return uts.set_type( u, inh ); }

  void set_replacement_template( cstring rt ) { replacement_template = rt; }

  /* search for target and modify it.  returns number of errors */
  int modify( void );

  dc_label *duplicate( dc_node *parent ) const;

  void set_undone( void ) { done = false; }
};

#endif
