/* pipe.h */

#ifndef PIPE__H
#define PIPE__H

#include "element.h"
#include "pipe_iface.h"

/* dc_pipes are a subclass of dc_element that query and set objects associated
   with their parent component
   pipe types, along with set and get info are all listed in pipe_table in 
   pipe_iface.

   on update a pipe will do one of two things
   if first update since reset and there is an initial value 
       will call set with value
   else if pipe has an evaluation function, will evaluate and set
   else will get.

   after a call to set caused by an explicit assignment, direction will be set 
   */
class dc_pipe : public dc_element {
private:
  cpipe_type pipe_type;
  bool direction; /* false to query */

protected:
  dc_pipe( void );

  /* called by constructor, so make sure that parent is set before this is 
     called */
  bool set_pipe_type( cpipe_type t );

public:
  /* if constructor is called with an invalid type then type will be undef_t */
  dc_pipe( cpipe_type, const string &label, dc_component *parent );
  //  ~dc_pipe();

  /* inherited functions */
  string type_string( void ) const { return string( "pipe" ); }
  
  cpipe_type get_pipe_type( void ) const { return pipe_type; }

  bool set( dc_data &d );

  //  ostream &display( ostream &stream = cout );
  friend ostream &operator<<( ostream &stream, dc_pipe &E ) {
    return E.display( stream );
  }

  bool update( void );
  void reset( void );
};

typedef list<dc_pipe *> pipe_list;

#endif
