/* rc_file.h */

#ifndef RC_FILE__H
#define RC_FILE__H

#include <LEDA/list.h>
#include "common.h"

/* loads an rc file, appending to any other loads.  returns true on error */
bool load_rc( cstring filename );

/* clears all rc state */
void clear_rc( void );

/* returns list of strings given variable name, or nil if not found.
   list should not be modified */
const list<string> *rc_get( cstring variable_name );
bool rc_defined( cstring variable_name );
string rc_out( cstring variable_name );

ostream &print_rc( ostream & = cout );

#endif



