#include <coriolis/kernel.h>
#include "junk.h"
#include "view3d.h"

#ifndef SIMPLE3D__H
#define SIMPLE3D__H

const color white_col( white );
const color black_col( black );
const color red_col( red );
const color blue_col( blue );

void init_view( void );
void close_view( void );
void clear_view( void );

void draw_link( triple src, triple tgt, bool directed, const color = red_col );
void draw_shape( Shape &, const color );

point project_to_screen( triple wp );

/* true if the y_axis increases in the positive direction */
const bool Y_AXIS_UP = true;

#endif
