/* user_types.h */

#ifndef USER_TYPES__H
#define USER_TYPES__H

#include <LEDA/basic.h>
#include <LEDA/dictionary.h>
#include <iostream.h>
#include "common.h"

typedef unsigned int user_type;

const user_type Undefined_Type = 0;
const user_type No_Type = 1;

bool isdef_type( cstring );
user_type define_u_type( cstring ); /* returns new user_type or if string 
				       already describes a type returns that */
bool undef_u_type( cstring );
bool undef_u_type( const user_type );
void undef_all_u_types( void );
string u_type_string( const user_type );
user_type parse_u_type( cstring );
bool add_u_type_impl( const user_type, const user_type );

void list_u_types( ostream & = cout );

class u_type_set {
private:
  dictionary<user_type, bool> D;
public:
  ~u_type_set( void );

  bool set_type( const user_type, const bool = false );
  /*  bool unset_type( const user_type ); */
  bool is_type( const user_type ) const;
  bool is_type( const user_type, bool &inh ) const;

  void inherit( const u_type_set & );
  void inherit_all( const u_type_set & );

  u_type_set &operator=( const u_type_set & );
  u_type_set &operator+=( const u_type_set & );

  string list_types( void ) const;
};

#endif
