/*****************************************************************************/
/*
  controller.c: control strategy.
*/
/*****************************************************************************/

#include <stdio.h>
#include <math.h>
#include <stdlib.h>

#include "matrix3.h"
#include "../useful/trajectory/trajectory.h"
#include "main.h"
#include "main2.h"
#include "sdfast/alien.h"
#include "sdfast/lander.h"

/*****************************************************************************/
/*****************************************************************************/
/* Global variables */

/*****************************************************************************/
/*****************************************************************************/

void reset_score( SIM *s )
{
}

/*****************************************************************************/
/*
Could normalize torque and other penalties w.r.t. distance
Could penalize deviations from symmetry (if necessary).
*/

double one_step_cost( SIM *s )
{
  return 0.0;
}

/*****************************************************************************/

void update_score( SIM *s )
{
}

/*****************************************************************************/

double get_score( SIM *s )
{
  return 0.0;
}

/*****************************************************************************/
/* call this many times to restart a simulation */

int reinit_controller( SIM *s )
{
  return 0;
}

/*****************************************************************************/
/* call this many times to restart a simulation */

int reinit_sim( SIM *s )
{
  int i;
  double min;
  double sdfast_state[MAX_N_SDFAST_STATE];

  srand( s->rand_seed );

  s->time = 0.0;

  // initialize alien artifact position
  sdfast_state[ALIEN_X] = 0;
  sdfast_state[ALIEN_Y] = 0;
  sdfast_state[ALIEN_Z] = 4.0;
  sdfast_state[ALIEN_Q0] = 0;
  sdfast_state[ALIEN_Q1] = 0;
  sdfast_state[ALIEN_Q2] = 0;
  sdfast_state[ALIEN_Q3] = 1.0;

  // initialize alien artifact velocity
  // change w to see how tumbling depends on I
  sdfast_state[ALIEN_XD] = 0.0;
  sdfast_state[ALIEN_YD] = 0.0;
  sdfast_state[ALIEN_ZD] = 0.0;
  sdfast_state[ALIEN_WX] = 0.3/3;
  sdfast_state[ALIEN_WY] = 1.0/3;
  sdfast_state[ALIEN_WZ] = 0.1/3;

  set_alien_sdfast_state( s, sdfast_state );

  // initialize lander position
  sdfast_state[LANDER_X] = 6.0;
  sdfast_state[LANDER_Y] = 11.0;
  sdfast_state[LANDER_Z] = 2.0;
  sdfast_state[LANDER_Q0] = 0;
  sdfast_state[LANDER_Q1] = 0;
  sdfast_state[LANDER_Q2] = 0;
  sdfast_state[LANDER_Q3] = 1.0;

  // a more twisty startup
  sdfast_state[LANDER_Q0] = -0.70710678118655;
  sdfast_state[LANDER_Q1] = 0.0;
  sdfast_state[LANDER_Q2] = -0.70710678118655;
  sdfast_state[LANDER_Q3] = 0.0;
  /*
  sdfast_state[LANDER_Q0] = 0.0;
  sdfast_state[LANDER_Q1] = 0.0;
  sdfast_state[LANDER_Q2] = 0.70710678118655;
  sdfast_state[LANDER_Q3] = 0.70710678118655;
  */

  // initialize lander velocity
  sdfast_state[LANDER_XD] = 0.0;
  sdfast_state[LANDER_YD] = 0.0;
  sdfast_state[LANDER_ZD] = 0.0;
  // w in body coordinates
  sdfast_state[LANDER_WX] = 0.0;
  sdfast_state[LANDER_WY] = 0.0;
  sdfast_state[LANDER_WZ] = 0.0;

  set_lander_sdfast_state( s, sdfast_state );

  // initialize xxx_q_last stuff
  s->alien_q_last[0] = sdfast_state[ALIEN_Q3];
  s->alien_q_last[1] = sdfast_state[ALIEN_Q0];
  s->alien_q_last[2] = sdfast_state[ALIEN_Q1];
  s->alien_q_last[3] = sdfast_state[ALIEN_Q2];
  s->lander_q_last[0] = sdfast_state[LANDER_Q3];
  s->lander_q_last[1] = sdfast_state[LANDER_Q0];
  s->lander_q_last[2] = sdfast_state[LANDER_Q1];
  s->lander_q_last[3] = sdfast_state[LANDER_Q2];

  reinit_controller( s );
}

/*****************************************************************************/
/* Call this once to do one time operations like memory allocation */

int init_sim( SIM *s )
{
  init_dynamics( s );
  reinit_sim( s );
}

/*****************************************************************************/
/*****************************************************************************/
/*****************************************************************************/

/*****************************************************************************/

int controller( SIM *s )
{
  int i;
  double k_x = 1.0;
  double b_x = 2.0;
  double k_r = 1.0;
  double b_r = 2.0;
  double q_minus[4];
  double q_diff[4];

  // desired lander position
  s->lander_x_d[XX] = 0.0;
  // s->lander_x_d[YY] = 6.0;
  s->lander_x_d[YY] = 11.0;
  s->lander_x_d[ZZ] = 4.0;

  // desired lander orientation
  s->lander_q_d[0] = 0.70710678118655;
  s->lander_q_d[1] = 0.0;
  s->lander_q_d[2] = 0.0;
  s->lander_q_d[3] = 0.70710678118655;

  // lander translational control (PD servo)
  for ( i = 0; i < 3; i++ )
    {
      s->lander_thrust_world[i] = 
	k_x*( s->lander_x_d[i] - s->lander_x[i] ) +
	b_x*( - s->lander_xd[i] );
    }
  multiply_transpose_m_v( s->lander_r, s->lander_thrust_world, 
		      s->lander_thrust );

  // lander orientation control
  // "subtract quaternions"
  invert_q( s->lander_q, q_minus );
  compose_q( q_minus, s->lander_q_d, q_diff );
  q_to_rotvec( q_diff, s->rotvec ); 
  // printf( "%g %g %g %g\n", q_diff[0], q_diff[1], q_diff[2], q_diff[3] );
  // printf( "%g %g %g\n", s->rotvec[0], s->rotvec[1], s->rotvec[2] );

  // PD servo for orientation
  // w and rotvec are in body coordinates.
  for ( i = 0; i < 3; i++ )
    {
      s->lander_torque[i] = k_r*s->rotvec[i] - b_r*s->lander_w[i];
    }
  multiply_m_v( s->lander_r, s->lander_torque, s->lander_torque_world );

  return 0;
}

/*****************************************************************************/
