((auto-complete status "installed" recipe
                (:name auto-complete :website "https://github.com/auto-complete/auto-complete" :description "The most intelligent auto-completion extension." :type github :pkgname "auto-complete/auto-complete" :depends
                       (popup fuzzy)
                       :after
                       (progn
                         (ome-auto-complete-setup))))
 (auto-complete-clang status "installed" recipe
                      (:name auto-complete-clang :website "https://github.com/brianjcj/auto-complete-clang" :description "Auto-complete sources for Clang. Combine the power of AC, Clang and Yasnippet." :type github :pkgname "brianjcj/auto-complete-clang" :depends auto-complete :after
                             (progn
                               (ome-auto-complete-clang-setup))))
 (autopair status "installed" recipe
           (:name autopair :website "https://github.com/capitaomorte/autopair" :description "Autopair is an extension to the Emacs text editor that automatically pairs braces and quotes." :type github :pkgname "capitaomorte/autopair" :features autopair :after
                  (progn
                    (autopair-global-mode 1))))
 (buffer-move status "installed" recipe
              (:name buffer-move :description "Swap buffers without typing C-x b on each window" :type emacswiki :features buffer-move :after
                     (progn
                       (require 'buffer-move)
                       (global-set-key
                        (kbd "C-c <left>")
                        'buf-move-left)
                       (global-set-key
                        (kbd "C-c <down>")
                        'buf-move-down)
                       (global-set-key
                        (kbd "C-c <up>")
                        'buf-move-up)
                       (global-set-key
                        (kbd "C-c <right>")
                        'buf-move-right))))
 (cl-lib status "installed" recipe
         (:name cl-lib :builtin "24.3" :type elpa :description "Properly prefixed CL functions and macros" :url "http://elpa.gnu.org/packages/cl-lib.html"))
 (dash status "installed" recipe
       (:name dash :description "A modern list api for Emacs. No 'cl required." :type github :pkgname "magnars/dash.el"))
 (dired+ status "installed" recipe
         (:name dired+ :description "Extensions to Dired" :type emacswiki :features dired+ :after
                (progn
                  (ome-dired+-setup))))
 (el-get status "installed" recipe
         (:name el-get :website "https://github.com/dimitri/el-get#readme" :description "Manage the external elisp bits and pieces you depend upon." :type github :branch "4.stable" :pkgname "dimitri/el-get" :info "." :load "el-get.el"))
 (evil status "installed" recipe
       (:name evil :website "http://gitorious.org/evil/pages/Home" :description "Evil is an extensible vi layer for Emacs. It\n       emulates the main features of Vim, and provides facilities\n       for writing custom extensions." :type git :url "git://gitorious.org/evil/evil.git" :features evil :depends undo-tree :build
              (("make" "all" "info"))
              :build/berkeley-unix
              (("gmake" "all" "info"))
              :info "doc" :after
              (progn
                (evil-setting))))
 (fic-mode status "installed" recipe
           (:name fic-mode :website "https://github.com/lewang/fic-mode#readme" :description "Show FIXME/TODO/BUG(...) in special face only in comments and strings" :type github :pkgname "lewang/fic-mode" :features fic-mode :after
                  (progn
                    (require 'fic-mode)
                    (add-hook 'c-common-mode-hook 'fic-mode))))
 (fuzzy status "installed" recipe
        (:name fuzzy :website "https://github.com/auto-complete/fuzzy-el" :description "Fuzzy matching utilities for GNU Emacs" :type github :pkgname "auto-complete/fuzzy-el"))
 (git-modes status "installed" recipe
            (:name git-modes :description "GNU Emacs modes for various Git-related files" :type github :pkgname "magit/git-modes"))
 (google-c-style status "installed" recipe
                 (:name google-c-style :type http :description "Google's C/C++ style for c-mode" :url "http://google-styleguide.googlecode.com/svn/trunk/google-c-style.el" :features google-c-style :post-init
                        (progn
                          (add-hook 'c-mode-common-hook 'google-set-c-style)
                          (add-hook 'c-mode-common-hook 'google-make-newline-indent))
                        :after
                        (progn
                          (add-hook 'c-mode-common-hook 'google-set-c-style))))
 (goto-chg status "installed" recipe
           (:name goto-chg :description "Goto the point of the most recent edit in the buffer." :type emacswiki :features goto-chg :after
                  (progn
                    (global-set-key
                     (kbd "C-o")
                     'goto-last-change))))
 (highlight-parentheses status "installed" recipe
                        (:name highlight-parentheses :description "Highlight the matching parentheses surrounding point." :type http :url "http://nschum.de/src/emacs/highlight-parentheses/highlight-parentheses.el" :features highlight-parentheses :after
                               (progn
                                 (require 'highlight-parentheses)
                                 (define-globalized-minor-mode global-highlight-parentheses-mode highlight-parentheses-mode
                                   (lambda nil
                                     (highlight-parentheses-mode t)))
                                 (global-highlight-parentheses-mode t))))
 (highlight-symbol status "installed" recipe
                   (:name highlight-symbol :description "Quickly highlight a symbol throughout the buffer and cycle through its locations." :type http :url "http://nschum.de/src/emacs/highlight-symbol/highlight-symbol.el" :features "highlight-symbol" :after
                          (progn
                            (hl-symbol-setting))))
 (htmlize status "installed" recipe
          (:name htmlize :website "http://www.emacswiki.org/emacs/Htmlize" :description "Convert buffer text and decorations to HTML." :type http :url "http://fly.srk.fer.hr/~hniksic/emacs/htmlize.el.cgi" :localname "htmlize.el"))
 (ibus status "installed" recipe
       (:name ibus :description "IBus client for GNU Emacs" :website "https://launchpad.net/ibus.el" :type http-tar :options
              ("xzf")
              :url "http://launchpad.net/ibus.el/0.3/0.3.2/+download/ibus-el-0.3.2.tar.gz" :post-init
              (add-hook 'after-init-hook 'ibus-mode-on)
              :features "ibus"))
 (imenu+ status "installed" recipe
         (:name imenu+ :auto-generated t :type emacswiki :description "Extensions to `imenu.el'." :website "https://raw.github.com/emacsmirror/emacswiki.org/master/imenu+.el" :after
                (progn
                  (imenu-config))))
 (key-chord status "installed" recipe
            (:name key-chord :description "Map pairs of simultaneously pressed keys to commands." :type emacswiki :features "key-chord" :after
                   (progn
                     (key-chord-setting))))
 (magit status "installed" recipe
        (:name magit :website "https://github.com/magit/magit#readme" :description "It's Magit! An Emacs mode for Git." :type github :pkgname "magit/magit" :depends
               (cl-lib git-modes)
               :info "." :build
               (if
                   (version<= "24.3" emacs-version)
                   `(("make" ,(format "EMACS=%s" el-get-emacs)
                      "all"))
                 `(("make" ,(format "EMACS=%s" el-get-emacs)
                    "docs")))
               :build/berkeley-unix
               (("touch" "`find . -name Makefile`")
                ("gmake"))
               :after
               (progn
                 (ome-magit-setup))))
 (markdown-mode status "installed" recipe
                (:name markdown-mode :description "Major mode to edit Markdown files in Emacs" :website "http://jblevins.org/projects/markdown-mode/" :type git :url "git://jblevins.org/git/markdown-mode.git" :before
                       (add-to-list 'auto-mode-alist
                                    '("\\.\\(md\\|mdown\\|markdown\\)\\'" . markdown-mode))))
 (move-text status "installed" recipe
            (:name move-text :auto-generated t :type emacswiki :description "Move current line or region with M-up or M-down." :website "https://raw.github.com/emacsmirror/emacswiki.org/master/move-text.el" :after
                   (progn
                     (mu-move-text-config))))
 (multi-eshell status "installed" recipe
               (:name multi-eshell :auto-generated t :type emacswiki :description "Create and manage multiple shells within Emacs" :website "https://raw.github.com/emacsmirror/emacswiki.org/master/multi-eshell.el" :after
                      (progn
                        (require 'multi-eshell))))
 (multi-shell status "installed" recipe
              (:name multi-shell :auto-generated t :type emacswiki :description "Multi-Shell Manager" :website "https://raw.github.com/emacsmirror/emacswiki.org/master/multi-shell.el"))
 (naquadah-theme status "installed" recipe
                 (:name naquadah-theme :description "Naquadah theme for Emacs" :type git :url "git://git.naquadah.org/naquadah-theme.git" :post-init
                        (add-to-list 'custom-theme-load-path default-directory)
                        :after
                        (progn
                          (require 'naquadah-theme))))
 (package status "installed" recipe
          (:name package :description "ELPA implementation (\"package.el\") from Emacs 24" :builtin "24" :type http :url "http://repo.or.cz/w/emacs.git/blob_plain/1a0a666f941c99882093d7bd08ced15033bc3f0c:/lisp/emacs-lisp/package.el" :shallow nil :features package :post-init
                 (progn
                   (setq package-user-dir
                         (expand-file-name
                          (convert-standard-filename
                           (concat
                            (file-name-as-directory default-directory)
                            "elpa")))
                         package-directory-list
                         (list
                          (file-name-as-directory package-user-dir)
                          "/usr/share/emacs/site-lisp/elpa/"))
                   (make-directory package-user-dir t)
                   (unless
                       (boundp 'package-subdirectory-regexp)
                     (defconst package-subdirectory-regexp "^\\([^.].*\\)-\\([0-9]+\\(?:[.][0-9]+\\)*\\)$" "Regular expression matching the name of\n a package subdirectory. The first subexpression is the package\n name. The second subexpression is the version string."))
                   (setq package-archives
                         '(("ELPA" . "http://tromey.com/elpa/")
                           ("gnu" . "http://elpa.gnu.org/packages/")
                           ("marmalade" . "http://marmalade-repo.org/packages/")
                           ("SC" . "http://joseito.republika.pl/sunrise-commander/"))))))
 (popup status "installed" recipe
        (:name popup :website "https://github.com/auto-complete/popup-el" :description "Visual Popup Interface Library for Emacs" :type github :pkgname "auto-complete/popup-el"))
 (protobuf-mode status "installed" recipe
                (:name protobuf-mode :website "http://code.google.com/p/protobuf/" :description "Major mode for editing protocol buffers." :type http :url "http://protobuf.googlecode.com/svn-history/trunk/editors/protobuf-mode.el" :features protobuf-mode :after
                       (progn
                         (require 'protobuf-mode))))
 (rainbow-mode status "installed" recipe
               (:name rainbow-mode :description "Colorize color names in buffers" :minimum-emacs-version 24 :type elpa))
 (smartparens status "installed" recipe
              (:name smartparens :description "Autoinsert pairs of defined brackets and wrap regions" :type github :pkgname "Fuco1/smartparens" :depends dash :after
                     (progn
                       (ome-sp-config))))
 (sourcepair status "installed" recipe
             (:name sourcepair :auto-generated t :type emacswiki :description "Load the corresponding C/C++ header or source file for the current buffer." :website "https://raw.github.com/emacsmirror/emacswiki.org/master/sourcepair.el" :after
                    (progn
                      (require 'sourcepair)
                      (add-hook 'c-mode-common-hook
                                (lambda nil
                                  (local-set-key "\350" 'sourcepair-load))))))
 (undo-tree status "installed" recipe
            (:name undo-tree :description "Treat undo history as a tree" :website "http://www.dr-qubit.org/emacs.php" :type git :url "http://www.dr-qubit.org/git/undo-tree.git/"))
 (window-numbering status "installed" recipe
                   (:name window-numbering :type http :website "http://nschum.de/src/emacs/window-numbering-mode/" :description "Assigns numbers to Emacs windows to allow easy window navigation" :url "http://nschum.de/src/emacs/window-numbering-mode/window-numbering.el"))
 (yasnippet status "installed" recipe
            (:name yasnippet :website "https://github.com/capitaomorte/yasnippet.git" :description "YASnippet is a template system for Emacs." :type github :pkgname "capitaomorte/yasnippet" :features "yasnippet" :pre-init
                   (unless
                       (or
                        (boundp 'yas/snippet-dirs)
                        (get 'yas/snippet-dirs 'customized-value))
                     (setq yas/snippet-dirs
                           (list
                            (concat el-get-dir
                                    (file-name-as-directory "yasnippet")
                                    "snippets"))))
                   :post-init
                   (put 'yas/snippet-dirs 'standard-value
                        (list
                         (list 'quote
                               (list
                                (concat el-get-dir
                                        (file-name-as-directory "yasnippet")
                                        "snippets")))))
                   :compile nil :submodule nil :depends
                   (popup)
                   :after
                   (progn
                     (setq yas-prompt-functions
                           '(yas-popup-isearch-prompt yas-no-prompt))
                     (yas-reload-all)
                     (add-hook 'prog-mode-hook
                               '(lambda nil
                                  (yas-minor-mode)))))))
