
(add-to-list 'auto-mode-alist '("\\.h\\'" . c++-mode))
(add-hook 'c-mode-common-hook
          (lambda ()
            (local-set-key [f8] 'gud-print)
            (local-set-key [f7] 'gud-step)
            (local-set-key [f6] 'gud-until)))

(add-to-list 'el-get-sources
             '(:name google-c-style
                     :after (progn
                              (add-hook 'c-mode-common-hook 'google-set-c-style))))
(add-to-list 'el-get-sources
             '(:name sourcepair
                     :after (progn
                              (require 'sourcepair)
                              (add-hook 'c-mode-common-hook
                                        (lambda ()
                                          (local-set-key "\M-h" 'sourcepair-load)
                                          )))))

;; (add-to-list 'el-get-sources
;;              '(:name highlight-symbol-mode
;;                :after (progn
;;                         (require 'highlight-symbol-mode)
;;                         (add-hook 'c-mode-common-hook
;;                                   (highlight-symbol-mode)
;;                                   ))))

(defun bury-compile-buffer-if-successful (buffer string)
  "Bury a compilation buffer if succeeded without warnings "
  (if (and
       (string-match "compilation" (buffer-name buffer))
       (string-match "finished" string)
       (not
        (with-current-buffer buffer
          (search-forward "warning" nil t))))
      (run-with-timer 1 nil
                      (lambda (buf)
                        (bury-buffer buf)
                        (switch-to-prev-buffer (get-buffer-window buf) 'kill))
                      buffer)))
(add-hook 'compilation-finish-functions 'bury-compile-buffer-if-successful)

(setq compilation-scroll-output t)
(defun smart-compile()
  (interactive)
  (let ((candidate-make-file-name '("makefile" "Makefile" "GNUmakefile"))
        (command nil))
    (if (not (null
              (find t candidate-make-file-name :key
                    '(lambda (f) (file-readable-p f)))))
        (setq command "make ")
        (if (null (buffer-file-name (current-buffer)))
            (message "Buffer not attached to a file, won't compile!")
            (if (eq major-mode 'c-mode)
                (setq command
                      (concat "gcc -Wall -o "
                              (file-name-sans-extension
                               (file-name-nondirectory buffer-file-name))
                              " "
                              (file-name-nondirectory buffer-file-name)
                              " -ggdb -lm -O2"))
              (if (eq major-mode 'c++-mode)
                  (setq command
                        (concat "g++ -Wall -o "
                                (file-name-sans-extension
                                 (file-name-nondirectory buffer-file-name))
                                " "
                                (file-name-nondirectory buffer-file-name)
                                " -ggdb -lm -O2"))
                (message "Unknow mode, won't compile!")))))
    (if (not (null command))
        (let ((command (read-from-minibuffer "Compile command: " command)))
          (compile command)))))

(add-hook 'c-mode-common-hook
          (lambda ()
          (local-set-key [f5] 'smart-compile)))
