
(add-to-list 'el-get-sources
             '(:name evil
                     :after (progn
                              (setq evil-auto-indent t)
                              (setq evil-regexp-search t)
                              (setq evil-want-C-i-jump t)
                              (setq evil-normal-state-cursor '("white" box))
                              (setq evil-insert-state-cursor '("white" bar))
                              (add-hook 'text-mode-hook 'turn-on-evil-mode)
                              (add-hook 'prog-mode-hook 'turn-on-evil-mode)
                              (add-hook 'comint-mode-hook 'turn-on-evil-mode)
                              (add-hook 'eshell-mode-hook 'turn-off-evil-mode)
                              (add-hook 'matlab-shell-mode-hook 'turn-off-evil-mode)
                              (add-hook 'Info-mode-hook 'turn-off-evil-mode))))

;; change mode-line color by evil state
;; (setq post-command-hook nil)
   (lexical-let ((default-color (cons (face-background 'mode-line)
                                      (face-foreground 'mode-line))))
     (add-hook 'post-command-hook
       (lambda ()
         (let ((color (cond ((minibufferp) default-color)
                            ((evil-insert-state-p) '("#AD013D" . "#ffffff"))
                            ((evil-emacs-state-p)  '("#444488" . "#ffffff"))
                            ((buffer-modified-p)   '("#006fa0" . "#ffffff"))
                            (t default-color))))
           (set-face-background 'mode-line (car color))
           (set-face-foreground 'mode-line (cdr color))))))

(eval-after-load 'popup
    '(progn
       (define-key popup-menu-keymap (kbd "M-n") 'popup-next)
       (define-key popup-menu-keymap (kbd "TAB") 'popup-next)
       (define-key popup-menu-keymap (kbd "<tab>") 'popup-next)
       (define-key popup-menu-keymap (kbd "<backtab>") 'popup-previous)
       (define-key popup-menu-keymap (kbd "M-p") 'popup-previous)))

  (defun yas-popup-isearch-prompt (prompt choices &optional display-fn)
    (when (featurep 'popup)
      (popup-menu*
       (mapcar
        (lambda (choice)
          (popup-make-item
           (or (and display-fn (funcall display-fn choice))
               choice)
           :value choice))
        choices)
       :prompt prompt
       ;; start isearch mode immediately
       :isearch t)))

  (add-to-list 'el-get-sources
               '(:name yasnippet
                       :depends (popup)
                       :after (progn
                                (setq yas-prompt-functions
                                      '(yas-popup-isearch-prompt
                                        yas-no-prompt))
                                (yas-reload-all)
                                (add-hook 'prog-mode-hook
                                          '(lambda ()
                                             (yas-minor-mode)))
)))

(defun ome-create-newline-and-enter-sexp (&rest _ignored)
    "Open a new brace or bracket expression, with relevant newlines and indent. "
    (newline)
    (indent-according-to-mode)
    (forward-line -1)
    (indent-according-to-mode))

  (defun ome-sp-config ()
    ;; global
    (require 'smartparens-config)
    (setq sp-autoskip-closing-pair 'always)
    (setq sp-navigate-close-if-unbalanced t)
    (smartparens-global-mode t)

    ;; no annoy red highlight
    (setq sp-highlight-pair-overlay nil)
    ;; highlights matching pairs
;;    (show-smartparens-global-mode t)

    ;; keybinding management
    (define-key sp-keymap (kbd "M-s f") 'sp-forward-sexp)
    (define-key sp-keymap (kbd "M-s b") 'sp-backward-sexp)

    (define-key sp-keymap (kbd "M-s d") 'sp-down-sexp)
    (define-key sp-keymap (kbd "M-s D") 'sp-backward-down-sexp)
    (define-key sp-keymap (kbd "M-s a") 'sp-beginning-of-sexp)
    (define-key sp-keymap (kbd "M-s e") 'sp-end-of-sexp)

    (define-key sp-keymap (kbd "M-s u") 'sp-up-sexp)
    ;; (define-key emacs-lisp-mode-map (kbd ")") 'sp-up-sexp)
    (define-key sp-keymap (kbd "M-s U") 'sp-backward-up-sexp)
    (define-key sp-keymap (kbd "M-s t") 'sp-transpose-sexp)

    (define-key sp-keymap (kbd "M-s n") 'sp-next-sexp)
    (define-key sp-keymap (kbd "M-s p") 'sp-previous-sexp)

    (define-key sp-keymap (kbd "M-s k") 'sp-kill-sexp)
    (define-key sp-keymap (kbd "M-s w") 'sp-copy-sexp)

    (define-key sp-keymap (kbd "M-s s") 'sp-forward-slurp-sexp)
    (define-key sp-keymap (kbd "M-s r") 'sp-forward-barf-sexp)
    (define-key sp-keymap (kbd "M-s S") 'sp-backward-slurp-sexp)
    (define-key sp-keymap (kbd "M-s R") 'sp-backward-barf-sexp)
    (define-key sp-keymap (kbd "M-s F") 'sp-forward-symbol)
    (define-key sp-keymap (kbd "M-s B") 'sp-backward-symbol)

    (define-key sp-keymap (kbd "M-s [") 'sp-select-previous-thing)
    (define-key sp-keymap (kbd "M-s ]") 'sp-select-next-thing)

    (define-key sp-keymap (kbd "M-s M-i") 'sp-splice-sexp)
    (define-key sp-keymap (kbd "M-s <delete>") 'sp-splice-sexp-killing-forward)
    (define-key sp-keymap (kbd "M-s <backspace>") 'sp-splice-sexp-killing-backward)
    (define-key sp-keymap (kbd "M-s M-<backspace>") 'sp-splice-sexp-killing-around)

    (define-key sp-keymap (kbd "M-s M-d") 'sp-unwrap-sexp)
    (define-key sp-keymap (kbd "M-s M-b") 'sp-backward-unwrap-sexp)

    (define-key sp-keymap (kbd "M-s M-t") 'sp-prefix-tag-object)
    (define-key sp-keymap (kbd "M-s M-p") 'sp-prefix-pair-object)
    (define-key sp-keymap (kbd "M-s M-c") 'sp-convolute-sexp)
    (define-key sp-keymap (kbd "M-s M-a") 'sp-absorb-sexp)
    (define-key sp-keymap (kbd "M-s M-e") 'sp-emit-sexp)
    (define-key sp-keymap (kbd "M-s M-p") 'sp-add-to-previous-sexp)
    (define-key sp-keymap (kbd "M-s M-n") 'sp-add-to-next-sexp)
    (define-key sp-keymap (kbd "M-s M-j") 'sp-join-sexp)
    (define-key sp-keymap (kbd "M-s M-s") 'sp-split-sexp)
    (define-key sp-keymap (kbd "M-s M-r") 'sp-raise-sexp)

    ;; pair management
    (sp-local-pair 'minibuffer-inactive-mode "'" nil :actions nil)

    ;; markdown-mode
    (sp-with-modes '(markdown-mode gfm-mode rst-mode)
      (sp-local-pair "*" "*" :bind "C-*")
      (sp-local-tag "2" "**" "**")
      (sp-local-tag "s" "```scheme" "```")
      (sp-local-tag "<"  "<_>" "</_>" :transform 'sp-match-sgml-tags))

    ;; tex-mode latex-mode
    (sp-with-modes '(tex-mode plain-tex-mode latex-mode)
      (sp-local-tag "i" "\"<" "\">"))

    ;; html-mode
    (sp-with-modes '(html-mode sgml-mode)
      (sp-local-pair "<" ">"))

    ;; lisp modes
    (sp-with-modes sp--lisp-modes
      (sp-local-pair "(" nil :bind "C-("))

    (dolist (mode '(c-mode c++-mode java-mode js2-mode sh-mode))
      (sp-local-pair mode
                     "{"
                     nil
                     :post-handlers
                     '((ome-create-newline-and-enter-sexp "RET")))))

  (add-to-list 'el-get-sources
               '(:name smartparens
                       :after (progn
                                (ome-sp-config))))

(add-to-list 'el-get-sources
             '(:name rainbow-mode))

(defun mu-move-text-config ()
  (require 'move-text)
  (global-set-key (kbd "M-<up>") 'move-text-up)
  (global-set-key (kbd "M-<down>") 'move-text-down) )

  (add-to-list 'el-get-sources '(:name move-text
                       :after (progn
                                (mu-move-text-config))))

(add-to-list 'el-get-sources
             '(:name buffer-move
               :after (progn
                        (require 'buffer-move)
                        (global-set-key (kbd "C-c <left>") 'buf-move-left)
                        (global-set-key (kbd "C-c <down>") 'buf-move-down)
                        (global-set-key (kbd "C-c <up>") 'buf-move-up)
                        (global-set-key (kbd "C-c <right>") 'buf-move-right))))

(add-to-list 'el-get-sources
             '(:name highlight-symbol
                     :after (progn
                              (require 'highlight-symbol)
                              (setq highlight-symbol-idle-delay .5)
                              (global-set-key (kbd "C-c h") 'highlight-symbol-mode)
                        )))
