
;; believe me, you don't need menubar, toolbar nor scrollbar
(dolist (mode '(tool-bar-mode scroll-bar-mode))
  (when (fboundp mode) (funcall mode -1)))

;; show column number and line number
(dolist (mode '(column-number-mode line-number-mode global-linum-mode))
  (when (fboundp mode) (funcall mode t)))

(setq linum-format "%3d\u2502 ")
;; make the fringe thinner (default is 8 in pixels)
(fringe-mode 0)

;; show parenthesis match
(show-paren-mode 1)
(setq show-paren-style 'parentheses)

;; Toggle line highlighting in all buffers
;; (global-hl-line-mode t)

(set-default-font "DejaVu Sans Mono-11")
;(set-default-font "Ubuntu Mono-13")
; (set-default-font "Menlo-15")

(set-fontset-font "fontset-default" 'han (font-spec :family "华文黑体" :size 16))
;(set-fontset-font (frame-parameter nil 'font) 'symbol '("华文黑体" . "unicode-bmp"))
;(set-fontset-font (frame-parameter nil 'font) 'cjk-misc '("华文黑体" . "unicode-bmp"))
;(set-fontset-font (frame-parameter nil 'font) 'bopomofo '("华文黑体" . "unicode-bmp"))

(add-to-list 'el-get-sources
             '(:name naquadah-theme
                     :after (progn
                              (require 'naquadah-theme))))
