
;; package name, matlab-mode
  (add-to-list 'load-path "~/.emacs.d/matlab")

  (autoload 'matlab-mode "matlab" "Enter MATLAB mode." t)
  (setq auto-mode-alist (cons '("\\.m\\'" . matlab-mode) auto-mode-alist))
  (autoload 'matlab-shell "matlab" "Interactive MATLAB mode." t)

  ;;  (setq matlab-indent-function-body t) ; if you want function bodies indented
  ;;  (setq matlab-verify-on-save-flag nil) ; turn off auto-verify on save

  (setq matlab-comment-region-s "% ")
  (setq matlab-shell-input-ring-size 5000)

  (global-set-key (kbd "<f1>") 'matlab-shell)

;;  (eval-after-load "matlab"
;;    '(progn
;;       (set-face-attribute 'matlab-cellbreak-face nil
;;:foreground "magenta" :overline "#2e88a3" :weight bold :height 2.0 :family "helvetica")))
  (add-hook 'matlab-mode-hook
        (lambda()
          (local-set-key (kbd "C-.") 'matlab-find-file-on-path)
          (local-set-key (kbd "M-r") 'matlab-shell-run-region)
          (local-set-key (kbd "M-;") 'matlab-comment-region)
          (local-set-key (kbd "C-j") 'ido-switch-buffer)
          (local-set-key (kbd "M-RET") 'matlab-shell-run-cell)
          (local-set-key (kbd "M-g") 'matlab-shell-run-cell)
          (local-set-key (kbd "M-f") 'matlab-shell-run-command)
          (highlight-symbol-mode)
          ))

  ;; (add-hook 'matlab-shell-mode-hook
  ;;    (lambda()
  ;;      (local-set-key (kbd "C-=") 'other-window)
  ;;      (local-set-key (kbd "C--") 'other-window)
  ;;      (local-set-key (kbd "C-<next>") 'other-window)
  ;;      (local-set-key (kbd "C-<prior>") 'other-window)
  ;;      (local-set-key (kbd "M-p") 'comint-previous-matching-input-from-input)
  ;;      (local-set-key (kbd "M-n") 'comint-next-matching-input-from-input)
  ;;    ))
