
(server-start)
  ;; name
  (setq frame-title-format "mu@emacs - %f")
  ;; auto revert buffer globally
  (global-auto-revert-mode t)
  ;; set TAB and indention
  (setq-default tab-width 4)
  (setq-default indent-tabs-mode nil)
  ;; y or n is suffice for a yes or no question
  (fset 'yes-or-no-p 'y-or-n-p)
  ;; always add new line to the end of a file
  (setq require-final-newline t)
  ;; add no new lines when "arrow-down key" at the end of a buffer
  (setq next-line-add-newlines nil)
  ;; prevent the annoying beep on errors
  (setq ring-bell-function 'ignore)
  ;; remove trailing whitespaces before save
  (add-hook 'before-save-hook 'delete-trailing-whitespace)
  ;; enable to support navigate in camelCase words
  (global-subword-mode t)
  ;; hide startup splash screen
  (setq inhibit-startup-screen t)

  ;; shell-mode settings
  ;(setq explicit-shell-file-name "/bin/bash")
  ;(setq shell-file-name "/bin/bash")
  ;; always insert at the bottom
  (setq comint-scroll-to-bottom-on-input t)
  ;; no duplicates in command history
  (setq comint-input-ignoredups t)
  ;; what to run when i press enter on a line above the current prompt
  (setq comint-get-old-input (lambda () ""))
  ;; max shell history size
  (setq comint-input-ring-size 1000)
  ;; show all in emacs interactive output
  (setenv "PAGER" "cat")
  ;; set lang to enable Chinese display in shell-mode
  (setenv "LANG" "en_US.UTF-8")

  ;; set text-mode as the default major mode, instead of fundamental-mode
  ;; The first of the two lines in parentheses tells Emacs to turn on Text mode
  ;; when you find a file, unless that file should go into some other mode, such
  ;; as C mode.
  (setq-default major-mode 'text-mode)

  ;; use icomplete in minibuffer
  ;(icomplete-mode t)

  ;; delete the selection with a keypress
  (delete-selection-mode t)
  ;; no cursor
  (blink-cursor-mode -1)

;; disable backup
(setq backup-inhibited t)
;; disable auto save
(setq auto-save-default nil)
;; auto-fill paragraphs when insert space or return
(setq-default auto-fill-function 'do-auto-fill)
;; default 80 chars a line
(setq-default fill-column 80)
(global-auto-revert-mode t)

(visual-line-mode)
  ;; believe me, you don't need menubar, toolbar nor scrollbar
  (dolist (mode '(tool-bar-mode scroll-bar-mode))
    (when (fboundp mode) (funcall mode -1)))

  ;; show column number and line number
  (dolist (mode '(column-number-mode line-number-mode ))
    (when (fboundp mode) (funcall mode t)))

 ;; this mode slows down emacs significantly
 ;; global-linum-mode
 ;; (setq linum-format "%3d\u2502 ")
  ;; make the fringe thinner (default is 8 in pixels)

  (show-paren-mode 1)
  (setq show-paren-style 'parentheses)

  ;; Toggle line highlighting in all buffers
  ;; (global-hl-line-mode t)
(setq scroll-step 3)

  (global-set-key (kbd "RET") 'reindent-then-newline-and-indent)

(require 'ido)                      ; ido is part of emacs
(ido-mode t)                        ; for both buffers and files
(setq
 ido-ignore-buffers               ; ignore these guys
 '("\\` " "^\*Mess" "^\*Back" ".*Completion" "^\*Ido")
; ido-work-directory-list '("~/" "~/Desktop" "~/Documents")
 ido-case-fold  t               ; be case-insensitive
 ido-use-filename-at-point nil    ; don't use filename at point (annoying)
 ido-use-url-at-point nil         ;  don't use url at point (annoying)
 ido-enable-flex-matching t       ; be flexible
 ido-max-prospects 4              ; don't spam my minibuffer
 ido-confirm-unique-completion nil) ; wait for RET, even with unique :completion

(setq ido-file-extensions-order '(".org" ".tex" ".m" ".proto" ".h" ".cpp" ".cc"))

(add-to-list 'completion-ignored-extensions ".gz")
(add-to-list 'completion-ignored-extensions ".d")
(add-to-list 'completion-ignored-extensions ".pb.cc")
(setq ido-ignore-extensions t)

(global-set-key (kbd "C-x b") 'ido-switch-buffer)
(global-set-key (kbd "C-j") 'ido-switch-buffer)

;  (add-to-list 'el-get-sources
;               '(:name naquadah-theme
;                       :after (progn
;                                (require 'naquadah-theme))))

(add-to-list 'el-get-sources
             '(:name autopair
               :after (progn
                       (autopair-global-mode 1)  )))

(defun evil-setting()
  (require 'evil)
  (evil-mode 1)
  (setq evil-auto-indent t)
  (setq evil-regexp-search t)
  (setq evil-want-C-i-jump t)
  (setq evil-normal-state-cursor '("white" box))
  (setq evil-insert-state-cursor '("white" bar))
  (add-hook 'text-mode-hook 'turn-on-evil-mode)
  (add-hook 'prog-mode-hook 'turn-on-evil-mode)
  (add-hook 'comint-mode-hook 'turn-on-evil-mode)
  ; (add-hook 'eshell-mode-hook 'turn-off-evil-mode)
  (add-hook 'matlab-shell-mode-hook 'turn-off-evil-mode)
  (add-hook 'Info-mode-hook 'turn-off-evil-mode)
  (add-hook 'reftex-select-label-mode-hook 'turn-off-evil-mode)
  )

(cond
 ((eq system-type 'windows-nt)
  )
 ((eq system-type 'gnu/linux)
  (add-to-list 'el-get-sources
               '(:name evil
                       :after (progn
                                (evil-setting)))))
 ((eq system-type 'darwin) ;; mac specific settings
   (add-to-list 'load-path "~/.emacs.d/evil")
   (evil-setting)))

(defun key-chord-setting()
  (eval-after-load 'evil
    '(progn
       (key-chord-mode 1)
       (key-chord-define evil-normal-state-map "kj" 'evil-force-normal-state)
       (key-chord-define evil-visual-state-map "kj" 'evil-change-to-previous-state)
       (key-chord-define evil-insert-state-map "kj" 'evil-normal-state)
       (key-chord-define evil-insert-state-map "jj" 'evil-normal-state)
       (key-chord-define evil-replace-state-map "kj" 'evil-normal-state))))

(add-to-list 'el-get-sources
             '(:name key-chord
                     :after (progn
                              (key-chord-setting))));

;; change mode-line color by evil state
;; (setq post-command-hook nil)
   (lexical-let ((default-color (cons (face-background 'mode-line)
                                      (face-foreground 'mode-line))))
     (add-hook 'post-command-hook
       (lambda ()
         (let ((color (cond ((minibufferp) default-color)
                            ((evil-insert-state-p) '("#AD013D" . "#ffffff"))
                            ((evil-emacs-state-p)  '("#444488" . "#ffffff"))
                            ((buffer-modified-p)   '("#006fa0" . "#ffffff"))
                            (t default-color))))
           (set-face-background 'mode-line (car color))
           (set-face-foreground 'mode-line (cdr color))))))

(eval-after-load 'evil
        '(progn
     (define-key evil-normal-state-map "c" nil)
     (define-key evil-motion-state-map "cu" 'universal-argument)
     (define-key key-translation-map (kbd "ch") (kbd "C-h"))
     (define-key key-translation-map (kbd "cx") (kbd "C-c C-x"))
     (define-key key-translation-map (kbd "cc") (kbd "C-g"))
     (define-key key-translation-map (kbd "cj") (kbd "C-x b"))
     (define-key key-translation-map (kbd "co") (kbd "C-x o"))
     (define-key key-translation-map (kbd "cf") (kbd "C-x C-f"))
     (define-key key-translation-map (kbd "cs") (kbd "C-x C-s"))
     (define-key key-translation-map (kbd "cn") [f9])
     (define-key key-translation-map (kbd "cm") [f10])

))

(eval-after-load 'popup
    '(progn
       (define-key popup-menu-keymap (kbd "M-n") 'popup-next)
       (define-key popup-menu-keymap (kbd "TAB") 'popup-next)
       (define-key popup-menu-keymap (kbd "<tab>") 'popup-next)
       (define-key popup-menu-keymap (kbd "<backtab>") 'popup-previous)
       (define-key popup-menu-keymap (kbd "M-p") 'popup-previous)))

  (defun yas-popup-isearch-prompt (prompt choices &optional display-fn)
    (when (featurep 'popup)
      (popup-menu*
       (mapcar
        (lambda (choice)
          (popup-make-item
           (or (and display-fn (funcall display-fn choice))
               choice)
           :value choice))
        choices)
       :prompt prompt
       ;; start isearch mode immediately
       :isearch t)))

  (add-to-list 'el-get-sources
               '(:name yasnippet
                       :depends (popup)
                       :after (progn
                                (setq yas-prompt-functions
                                      '(yas-popup-isearch-prompt
                                        yas-no-prompt))
                                (yas-reload-all)
                                (add-hook 'prog-mode-hook
                                          '(lambda ()
                                             (yas-minor-mode)))
)))

(add-to-list 'el-get-sources
             '(:name highlight-parentheses
                     :after (progn
                              (require 'highlight-parentheses)
                              (define-globalized-minor-mode global-highlight-parentheses-mode
                                highlight-parentheses-mode
                                (lambda ()
                                  (highlight-parentheses-mode t)))
                              (global-highlight-parentheses-mode t)
                              )))

(add-to-list 'el-get-sources
             '(:name rainbow-mode))

(defun mu-move-text-config ()
  (require 'move-text)
  (global-set-key (kbd "M-<up>") 'move-text-up)
  (global-set-key (kbd "M-<down>") 'move-text-down) )

  (add-to-list 'el-get-sources '(:name move-text
                       :after (progn
                                (mu-move-text-config))))

(add-to-list 'el-get-sources
             '(:name buffer-move
               :after (progn
                        (require 'buffer-move)
                        (global-set-key (kbd "C-c <left>") 'buf-move-left)
                        (global-set-key (kbd "C-c <down>") 'buf-move-down)
                        (global-set-key (kbd "C-c <up>") 'buf-move-up)
                        (global-set-key (kbd "C-c <right>") 'buf-move-right))))

(defun hl-symbol-setting()
  (require 'highlight-symbol)
  (setq highlight-symbol-idle-delay .5)
  (global-set-key (kbd "C-c h") 'highlight-symbol-mode)

   ;; (define-globalized-minor-mode global-highlight-symbol-mode
   ;;   highlight-symbol-mode
   ;;   (lambda ()
   ;;     (highlight-symbol-mode t)))
   ;; (global-highlight-symbol-mode t)
  ;; (add-hook 'c-common-mode-hook 'highlight-symbol-mode)
  )
(add-to-list 'el-get-sources
             '(:name highlight-symbol
                     :after (progn
                              (hl-symbol-setting)
                              )))

(global-set-key (kbd "M-SPC") 'set-mark-command)

(global-set-key (kbd "C-x \\") 'align-regexp)

(global-set-key (kbd "M-/") 'hippie-expand)

(define-key global-map (kbd "C-=") 'text-scale-increase)
(define-key global-map (kbd "C--") 'text-scale-decrease)

(global-set-key (kbd "C-s") 'isearch-forward-regexp)
(global-set-key (kbd "C-r") 'isearch-backward-regexp)
(global-set-key (kbd "C-M-s") 'isearch-forward)
(global-set-key (kbd "C-M-r") 'isearch-backward)

(global-set-key (kbd "C-x M-f") 'ido-find-file-other-window)
  (global-set-key (kbd "C-x C-p") 'find-file-at-point)
  (global-set-key [f4] 'ido-kill-buffer)
  (global-set-key (kbd "C-q") 'ido-kill-buffer)
  (global-set-key (kbd "C-c r") 'revert-buffer)
;  (global-set-key (kbd "M-`") 'file-cache-minibuffer-complete)
;  (global-set-key (kbd "C-x C-b") 'ibuffer)

(windmove-default-keybindings) ;; Shift + arrow keys
;  (global-set-key "`" 'other-window)
;  (global-set-key (kbd "C-x O") (lambda () (interactive) (other-window -1))) ;; back one
;  (global-set-key (kbd "C-x C-o") (lambda () (interactive) (other-window 2))) ;; forward two

(global-set-key (kbd "M-s") 'replace-string)

(global-set-key (kbd "C-c o") 'occur)

(add-to-list 'el-get-sources
               '(:name goto-chg
                       :after (progn
(global-set-key (kbd "C-o") 'goto-last-change))))

(add-to-list 'el-get-sources
               '(:name multi-eshell
                       :after (progn
                                (require 'multi-eshell))))
(setq multi-eshell-shell-function '(eshell))
(setq multi-eshell-name "*eshell*")
(global-set-key [f3] 'multi-eshell)
(global-set-key [f2] 'multi-eshell-switch)
(setq eshell-ls-use-in-dired 1) ; ? no use
(add-hook 'eshell-mode-hook
          (lambda ()
            (local-set-key "\C-j" 'ido-switch-buffer)))

(defun eshell/clear ()
  (interactive)
  (let ((inhibit-read-only t))
    (erase-buffer)))

;; package name, matlab-mode
  (add-to-list 'load-path "~/.emacs.d/matlab")

  (autoload 'matlab-mode "matlab" "Enter MATLAB mode." t)
  (setq auto-mode-alist (cons '("\\.m\\'" . matlab-mode) auto-mode-alist))
  (autoload 'matlab-shell "matlab" "Interactive MATLAB mode." t)

  ;;  (setq matlab-indent-function-body t) ; if you want function bodies indented
  ;;  (setq matlab-verify-on-save-flag nil) ; turn off auto-verify on save

  (setq matlab-comment-region-s "% ")
  (setq matlab-shell-input-ring-size 5000)

  (global-set-key (kbd "<f1>") 'matlab-shell)

;;  (eval-after-load "matlab"
;;    '(progn
;;       (set-face-attribute 'matlab-cellbreak-face nil
;;:foreground "magenta" :overline "#2e88a3" :weight bold :height 2.0 :family "helvetica")))
  (add-hook 'matlab-mode-hook
        (lambda()
          (local-set-key (kbd "C-.") 'matlab-find-file-on-path)
          (local-set-key (kbd "M-r") 'matlab-shell-run-region)
          (local-set-key (kbd "M-;") 'xxx-comment-dwim-line)
          (local-set-key (kbd "C-j") 'ido-switch-buffer)
          (local-set-key (kbd "M-RET") 'matlab-shell-run-cell)
          (local-set-key (kbd "M-g") 'matlab-shell-run-cell)
          (local-set-key (kbd "M-f") 'matlab-shell-run-command)
          (highlight-symbol-mode)
          ))

  ;; (add-hook 'matlab-shell-mode-hook
  ;;    (lambda()
  ;;      (local-set-key (kbd "C-=") 'other-window)
  ;;      (local-set-key (kbd "C--") 'other-window)
  ;;      (local-set-key (kbd "C-<next>") 'other-window)
  ;;      (local-set-key (kbd "C-<prior>") 'other-window)
  ;;      (local-set-key (kbd "M-p") 'comint-previous-matching-input-from-input)
  ;;      (local-set-key (kbd "M-n") 'comint-next-matching-input-from-input)
  ;;    ))

;;;;;;;;;;;; comment ;;;;;;;;;;;;
(defun xxx-comment-dwim-line (&optional arg)
  "Replacement for the comment-dwim command.
If no region is selected and current line is not blank and we are not at the end of the line,
then comment current line.
Replaces default behaviour of comment-dwim, when it inserts comment at the end of the line."
  (interactive "*P")
  (comment-normalize-vars)
  (if (and (not (region-active-p)) (not (looking-at "[ \t]*$")))
      (comment-or-uncomment-region (line-beginning-position) (line-end-position))
    (comment-dwim arg)))
 (global-set-key "\M-;" 'xxx-comment-dwim-line)

(defun open-file-fast (openCode)
  "Prompt to open a file from a pre-defined set."
  (interactive "sOpen file: [e]macs [a]ccount [w]riting [l]nux > ")
  (let (ξfile)
    (setq ξfile
          (cond
           ((string= openCode "e") "~/.emacs.d/mu.org" )
           ((string= openCode "a") "~/Dropbox/org/account.org.gpg" )
           ((string= openCode "w") "~/Dropbox/org/writing.org" )
           ((string= openCode "l") "~/Dropbox/org/deft/linux.org" )
           (t (error "You typed %s, it doesn't associate with a file." openCode ))
           )
          )
    (find-file ξfile ) ) )
(global-set-key (kbd "M-z") 'open-file-fast)

;; (desktop-save-mode 1)
;; (setq desktop-buffers-not-to-save
;;       (concat "\\("
;;           "^nn\\.a[0-9]+\\|\\.log\\|(ftp)\\|^tags\\|^TAGS"
;;           "\\|\\.emacs.*\\|\\.diary\\|\\.newsrc-dribble\\|\\.bbdb"
;;           "\\)$"))

;; (add-to-list 'desktop-modes-not-to-save 'dired-mode)
;; (add-to-list 'desktop-modes-not-to-save 'Info-mode)
;; (add-to-list 'desktop-modes-not-to-save 'info-lookup-mode)
;; (add-to-list 'desktop-modes-not-to-save 'fundamental-mode)

(add-hook 'org-mode-hook (lambda ()
                           ;; (local-set-key "\M-i" 'org-toggle-iimage-in-org)
                           (local-set-key "\C-j" 'ido-switch-buffer)
                           (yas-minor-mode)
                           (flyspell-mode)
                           ))

;(require 'idomenu)
(defun imenu-config()
  (require 'imenu+)
  (defun ido-goto-symbol (&optional symbol-list)
    "Refresh imenu and jump to a place in the buffer using Ido."
    (interactive)
    (unless (featurep 'imenu)
      (require 'imenu nil t))
    (cond
     ((not symbol-list)
      (let ((ido-mode ido-mode)
            (ido-enable-flex-matching
             (if (boundp 'ido-enable-flex-matching)
                 ido-enable-flex-matching t))
            name-and-pos symbol-names position)
        (unless ido-mode
          (ido-mode 1)
          (setq ido-enable-flex-matching t))
        (while (progn
                 (imenu--cleanup)
                 (setq imenu--index-alist nil)
                 (ido-goto-symbol (imenu--make-index-alist))
                 (setq selected-symbol
                       (ido-completing-read "Symbol? " symbol-names))
                 (string= (car imenu--rescan-item) selected-symbol)))
        (unless (and (boundp 'mark-active) mark-active)
          (push-mark nil t nil))
        (setq position (cdr (assoc selected-symbol name-and-pos)))
        (cond
         ((overlayp position)
          (goto-char (overlay-start position)))
         (t
          (goto-char position)))))
     ((listp symbol-list)
      (dolist (symbol symbol-list)
        (let (name position)
          (cond
           ((and (listp symbol) (imenu--subalist-p symbol))
            (ido-goto-symbol symbol))
           ((listp symbol)
            (setq name (car symbol))
            (setq position (cdr symbol)))
           ((stringp symbol)
            (setq name symbol)
            (setq position
                  (get-text-property 1 'org-imenu-marker symbol))))
          (unless (or (null position) (null name)
                      (string= (car imenu--rescan-item) name))
            (add-to-list 'symbol-names name)
            (add-to-list 'name-and-pos (cons name position))))))))
  (global-set-key "\C-ci" 'ido-goto-symbol))

(add-to-list 'el-get-sources
             '(:name imenu+
                     :after (progn
                              (imenu-config))))

(add-to-list 'el-get-sources
             '(:name google-c-style
                     :after (progn
                              (add-hook 'c-mode-common-hook 'google-set-c-style))))

(add-to-list 'el-get-sources
             '(:name sourcepair
                     :after (progn
                              (require 'sourcepair)
                              (add-hook 'c-mode-common-hook
                                        (lambda ()
                                          (local-set-key "\M-h" 'sourcepair-load)
                                          )))))

(defun bury-compile-buffer-if-successful (buffer string)
      "Bury a compilation buffer if succeeded without warnings "
      (if (and
           (string-match "compilation" (buffer-name buffer))
           (string-match "finished" string)
           (not
            (with-current-buffer buffer
              (search-forward "warning" nil t))))
          (run-with-timer 1 nil
                          (lambda (buf)
                            (bury-buffer buf)
                            (switch-to-prev-buffer (get-buffer-window buf)
    'kill))
                          buffer)))
    (add-hook 'compilation-finish-functions 'bury-compile-buffer-if-successful)

    (setq compilation-scroll-output t)
    (defun smart-compile()
      (interactive)
      (let ((candidate-make-file-name '("makefile" "Makefile"))
            (candidate-make-file-name-1 '("../makefile" "../Makefile"))
            (candidate-make-file-name-2 '("../../makefile" "../../Makefile"))
            (candidate-make-file-name-3 '("../../../makefile"
    "../../../Makefile"))
            (candidate-make-file-name-4 '("../../../../makefile"
    "../../../../Makefile"))
            (command nil))
        (if (not (null (find t candidate-make-file-name :key '(lambda (f)
    (file-readable-p f)))))
            (setq command "make -j8")
          (if (not (null (find t candidate-make-file-name-1 :key '(lambda (f)
    (file-readable-p f)))))
              (setq command "make -j8 -C ..")
            (if (not (null (find t candidate-make-file-name-2 :key '(lambda (f)
    (file-readable-p f)))))
                (setq command "make -j8 -C ../..")
              (if (not (null (find t candidate-make-file-name-3 :key '(lambda
    (f) (file-readable-p f)))))
                  (setq command "make -j8 -C ../../..")
                (if (not (null (find t candidate-make-file-name-4 :key '(lambda
    (f) (file-readable-p f)))))
                    (setq command "make -j8 -C ../../../..")
                  (if (null (buffer-file-name (current-buffer)))
                      (message "Buffer not attached to a file, won't compile!")
                    (if (eq major-mode 'c-mode)
                        (setq command
                              (concat "gcc -Wall -o "
                                      (file-name-sans-extension
                                       (file-name-nondirectory
    buffer-file-name))
                                      " "
                                      (file-name-nondirectory buffer-file-name)
                                      " -ggdb -lm -O2"))
                      (if (eq major-mode 'c++-mode)
                          (setq command
                                (concat "g++ -Wall -o "
                                        (file-name-sans-extension
                                         (file-name-nondirectory
    buffer-file-name))
                                        " "
                                        (file-name-nondirectory
    buffer-file-name)
                                        " -ggdb -lm -O2"))
                        (message "Unknow mode, won't compile!")))))))))
        (if (not (null command))
            (let ((command (read-from-minibuffer "Compile command: " command)))
              (compile command)))))

(add-hook 'c-mode-common-hook
          (lambda ()
          (local-set-key [f5] 'smart-compile)))

(add-hook 'makefile-mode-hook
          (lambda ()
          (local-set-key [f5] 'smart-compile)))
(add-hook 'eshell-mode-hook
          (lambda ()
          (local-set-key [f5] 'smart-compile)))

(add-to-list 'auto-mode-alist '("\\.h\\'" . c++-mode))
(add-hook 'c-common-mode-hook (lambda ()
                                (flyspell-prog-mode)
                                (highlight-symbol-mode t)
                                ))

                                        ; (add-hook 'c-common-mode-hook (flyspell-prog-mode)))

;; ;(require 'cedet)
;; (semantic-mode 1)
;; (global-semantic-idle-summary-mode 1)
;; ;(global-semantic-show-unmatched-syntax-mode 1)
;; (global-semantic-mru-bookmark-mode 1)
;; ;(global-semantic-highlight-edits-mode -1)
;; ;(require 'semantic/analyze/refs)

;; (defadvice push-mark (around semantic-mru-bookmark activate)
;;   "Push a mark at LOCATION with NOMSG and ACTIVATE passed to `push-mark'.
;; If `semantic-mru-bookmark-mode' is active, also push a tag onto
;; the mru bookmark stack."
;;   (semantic-mrub-push semantic-mru-bookmark-ring
;;                       (point)
;;                       'mark)
;;   ad-do-it)

;; (defun semantic-ia-fast-jump-back ()
;;   (interactive)
;;   (if (ring-empty-p (oref semantic-mru-bookmark-ring ring))
;;       (error "Semantic Bookmark ring is currently empty"))
;;   (let* ((ring (oref semantic-mru-bookmark-ring ring))
;;          (alist (semantic-mrub-ring-to-assoc-list ring))
;;          (first (cdr (car alist))))
;;     (if (semantic-equivalent-tag-p (oref first tag) (semantic-current-tag))
;;         (setq first (cdr (car (cdr alist)))))
;;     (semantic-mrub-switch-tags first)))

;; (add-hook 'c-mode-common-hook
;;           (lambda ()
;;     (local-set-key [f9] 'semantic-ia-fast-jump)
;;     (local-set-key [f10] 'semantic-ia-fast-jump-back)))

(add-to-list 'el-get-sources
                 '(:name fic-mode
                         :after (progn
                                  (require 'fic-mode)
(add-hook 'c-common-mode-hook 'fic-mode)
                            )))

(add-to-list 'el-get-sources
             '(:name protobuf-mode
                     :after (progn
                         (require 'protobuf-mode)
                        )))

(when (eq system-type 'darwin) ;; mac specific settings
  ;; (setq mac-option-modifier 'alt)
   (setq mac-command-modifier 'meta)
  )

(global-set-key (kbd "C-x C-b") 'ibuffer)

(global-set-key (kbd "C-<tab>") 'ibuffer)
    (setq ibuffer-saved-filter-groups
          (quote (("default"
                   ("org" (mode . org-mode))
                   ("TeX" (or
                           (mode . latex-mode)
                           (mode . tex-mode)))
                   ("Matlab" (or
                              (mode . matlab-mode)
                              (mode . matlab-shell-mode)))
                   ("C/C++" (or
                             (mode . "\\.h$")
                             (mode . "\\.cpp$")
                             (mode . c-mode)
                             (mode . c++-mode))
                    )
                   ("Perl" (mode . cperl-mode))
                   ("Man" (mode . Man-mode))
                   ("emacs" (or
                             (name . "^\\*scratch\\*$")
                             (name . "^\\*Messages\\*$")
                             (name . "^\\.emacs$")
                             (mode . emacs-lisp-mode)))
                   ("sunrise" (mode . sr-mode))
                   ))))
    (add-hook 'ibuffer-mode-hook
              (lambda ()
                (ibuffer-switch-to-saved-filter-groups "default") ))

(defun ome-magit-setup ()
  (global-set-key [f6] 'magit-status)
    )
(ome-install 'magit)

(defun ome-auto-complete-setup ()
  (require 'auto-complete-config)

  (dolist (ac-mode '(text-mode org-mode))
    (add-to-list 'ac-modes ac-mode))
  (dolist (ac-mode-hook '(text-mode-hook org-mode-hook))
    (add-hook ac-mode-hook
              (lambda ()
                (add-to-list 'ac-sources 'ac-source-files-in-current-dir)
                (add-to-list 'ac-sources 'ac-source-filename))))

  (ac-config-default))

(ome-install 'auto-complete)

(defun ac-pcomplete ()
  ;; eshell uses `insert-and-inherit' to insert a \t if no completion
  ;; can be found, but this must not happen as auto-complete source
  (flet ((insert-and-inherit (&rest args)))
    ;; this code is stolen from `pcomplete' in pcomplete.el
    (let* (tramp-mode ;; do not automatically complete remote stuff
           (pcomplete-stub)
           (pcomplete-show-list t) ;; inhibit patterns like * being deleted
           pcomplete-seen pcomplete-norm-func
           pcomplete-args pcomplete-last pcomplete-index
           (pcomplete-autolist pcomplete-autolist)
           (pcomplete-suffix-list pcomplete-suffix-list)
           (candidates (pcomplete-completions))
           (beg (pcomplete-begin))
           ;; note, buffer text and completion argument may be
           ;; different because the buffer text may bet transformed
           ;; before being completed (e.g. variables like $HOME may be
           ;; expanded)
           (buftext (buffer-substring beg (point)))
           (arg (nth pcomplete-index pcomplete-args)))
      ;; we auto-complete only if the stub is non-empty and matches
      ;; the end of the buffer text
      (when (and (not (zerop (length pcomplete-stub)))
                 (or (string= pcomplete-stub ; Emacs 23
                              (substring buftext
                                         (max 0
                                              (- (length buftext)
                                                 (length pcomplete-stub)))))
                     (string= pcomplete-stub ; Emacs 24
                              (substring arg
                                         (max 0
                                              (- (length arg)
                                                 (length pcomplete-stub)))))))
        ;; Collect all possible completions for the stub. Note that
        ;; `candidates` may be a function, that's why we use
        ;; `all-completions`.
        (let* ((cnds (all-completions pcomplete-stub candidates))
               (bnds (completion-boundaries pcomplete-stub
                                            candidates
                                            nil
                                            ""))
               (skip (- (length pcomplete-stub) (car bnds))))
          ;; We replace the stub at the beginning of each candidate by
          ;; the real buffer content.
          (mapcar #'(lambda (cand) (concat buftext (substring cand skip)))
                  cnds))))))

(defvar ac-source-pcomplete
  '((candidates . ac-pcomplete)))

;; (defun ome-pkg-config-enable-clang-flag (pkg-config-lib)
;;   "This function will add necessary header file path of a
;; specified by `pkg-config-lib' to `ac-clang-flags', which make it
;; completionable by auto-complete-clang"
;;   (interactive "spkg-config lib: ")
;;   (if (executable-find "pkg-config")
;;       (if (= (shell-command
;;               (format "pkg-config %s" pkg-config-lib))
;;              0)
;;           (setq ac-clang-flags
;;                 (append ac-clang-flags
;;                         (split-string
;;                          (shell-command-to-string
;;                           (format "pkg-config --cflags-only-I %s"
;;                                   pkg-config-lib)))))
;;         (message "Error, pkg-config lib %s not found." pkg-config-lib))
;;     (message "Error: pkg-config tool not found.")))

;; ;; (ome-pkg-config-enable-clang-flag "QtGui")

;; (defun ome-auto-complete-clang-setup ()
;;   (require 'auto-complete-clang)
;;   (setq command "echo | g++ -v -x c++ -E - 2>&1 |
;;                  grep -A 20 starts | grep include | grep -v search")
;;   (setq ac-clang-flags
;;         (mapcar (lambda (item)
;;                   (concat "-I" item))
;;                 (split-string
;;                  (shell-command-to-string command))))
;;   ;; completion for C/C++ macros.
;;   (push "-code-completion-macros" ac-clang-flags)
;;   (push "-code-completion-patterns" ac-clang-flags)
;;   (dolist (mode-hook '(c-mode-hook c++-mode-hook))
;;     (add-hook mode-hook
;;               (lambda ()
;;                 (add-to-list 'ac-sources 'ac-source-clang)))))

;; (when (executable-find "clang")
;;   (ome-install 'auto-complete-clang))

(require  'uniquify)
(setq uniquify-buffer-name-style 'reverse)
(setq uniquify-separator "/")
(setq uniquify-after-kill-buffer-p t) ; rename after killing uniquified
(setq uniquify-ignore-buffers-re "^\\*") ; don't muck with special buffers

; (evilnc-default-hotkeys)

; (ome-install 'ibus)

(defun ome-dired+-setup ()
  (require 'dired+)
      )
  (ome-install 'dired+)

(global-set-key [f9] 'gud-gdb)
