
(defun ome-auctex-setup ()
  (when (require 'smartparens nil 'noerror)
    (require 'smartparens-latex))
  (setq TeX-auto-save t)                ; Automatically save style information
                                        ; when saving the buffer
  (setq TeX-parse-self t)               ; Parse file after loading it if no
                                        ; style hook is found for it.
  (setq LaTeX-syntactic-comment t)
  (setq TeX-auto-untabify t)            ; remove all tabs before saving
  (setq reftex-plug-into-AUCTeX t)
  (setq-default TeX-engine 'latex)      ; use xelatex by default

  ;; Currently, only linux system are tested. Patches for Mac OS and Windows
  ;; are always welcome.
  (cond
   ((eq system-type 'gnu/linux)
    (cond
     ((executable-find "okular")
      (setq TeX-view-program-selection
            '((output-pdf "Okular")
              (output-dvi "Okular"))))
     ((executable-find "evince")
      (setq TeX-view-program-selection
            '((output-pdf "Evince")
              (output-dvi "Evince"))))
     (t
      (setq TeX-view-program-selection
            '((output-pdf "xdg-open")
              (output-dvi "xdg-open")))))))

  (add-hook 'TeX-mode-hook
            (lambda ()
              (outline-minor-mode t)
              (flyspell-mode t)
              (TeX-interactive-mode t)
              (TeX-PDF-mode t)
              (TeX-fold-mode t)))

  (add-hook 'LaTeX-mode-hook
            (lambda ()
              (LaTeX-math-mode t)
              (reftex-mode t)))

  (add-hook 'reftex-toc-mode-hook
            (lambda ()
              (when (featurep 'evil)
                (turn-off-evil-mode)))))

(add-to-list 'el-get-sources
             '(:name auctex
                     :after (progn
                              (ome-auctex-setup))))

(defun ome-cdlatex-setup ()
  (add-hook 'LaTeX-mode-hook 'turn-on-cdlatex)
  (add-hook 'latex-mode-hook 'turn-on-cdlatex))

(when (el-get-package-is-installed 'auctex)
  (add-to-list 'el-get-sources
               '(:name cdlatex-mode
                       :after (progn
                                (ome-cdlatex-setup)))))
