/* awnode.h -- abstract class for worklet node signal processing
 *
 * Roger B. Dannenberg
 * Oct 2023
 */


class Awnode {
  public:
    int class_id;  // should be unique for each subclass and match get_class_id()
    bool stop;  // set this to request node to stop
    bool stopped;  // to be set by node when it stops
    PmQueue *queue;

    virtual ~Awnode() = default;

    
    virtual EM_BOOL process(int numInputs, const AudioSampleFrame *inputs,
                            int numOutputs, AudioSampleFrame *outputs,
                            int numParams, const AudioParamFrame *params) = 0;


    virtual void message_handler(char *msg) = 0;


    // copy all k samples from output 0 channel 0 to all outputs i channels j
    void mono_to_all(int numOutputs, AudioSampleFrame *outputs) {
        for (int i = 0; i < numOutputs; i++) {
            for (int j = 1; j < outputs[i].numberOfChannels; j++) {
                for (int k = 0; k < 128; k++) {
                    outputs[i].data[j * 128 + k] = outputs[0].data[k];
                }
            }
        }
    }
};
