/* awutil.h -- utility (helper) functions for audio worklets
 *
 * Roger B. Dannenberg
 * Oct 2023
 *
 * based on emscripten test code
 */

#include <emscripten/webaudio.h>
#include <emscripten/bind.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <assert.h>
#include "pmutil.h"
#include "awnode.h"

extern bool main_has_run;

void register_audio_worklet_class(std::string name, Awnode *(*constructor)());

int worklet_create();

int audio_node_create(std::string name);

void send_message_to_node(int id, int class_id, char *msg);


