/* sinetone.h -- an audio worklet kernel for "sntn"
 *
 * Roger B. Dannenberg
 * Oct 2023
 */

class Sinetone : public Awnode {
  public:
    float gain;
    float phase;
    float phase_inc;

    Sinetone();
    
    ~Sinetone();
    
    EM_BOOL process(int numInputs, const AudioSampleFrame *inputs,
                    int numOutputs, AudioSampleFrame *outputs,
                    int numParams, const AudioParamFrame *params);

    void message_handler(char *msg);
};


Awnode *sinetone_constructor();

void sinetone_set_gain(int id, float g);
void sinetone_set_freq(int id, float hz);
