function [ W W_ ] = NNgraph( data, K, j, classnum, method_name, U, Y, N )
        
    NNgraph_file = sprintf( 'NNgraphs/NN_%s_%d_%d_%d_%s.mat', data, K, j, classnum, method_name );    
    if length( dir( NNgraph_file ) ) == 0
        if strcmp( method_name, 'dtm' )
            [ W W_ ] = build_NNgraph_dtm( U, Y, K );
        elseif strcmp( method_name, 'ltm' )
            W = build_NNgraph_ltm( U, Y, K );
            W_ = [];
        elseif strcmp( method_name, 'LapPLSI' )
            W = build_NNgraph_LapPLSI( U, Y, K );
            W_ = [];
        end
        save( NNgraph_file, 'W', 'W_' );
    else
        load( NNgraph_file );
    end
