function [ acc1, acc2, acc3, acc4, bestvalaccuracy ] = compute_accuracies( X, N, R, Y, labeled_id, unlabeled_id, classnum )

    labeled_per_class = length(labeled_id) / classnum;   
    bestvalaccuracy = 0.0;
    
    if labeled_per_class > 0
        rangeC = 0:20; %log10( 1/mean(sum(X(:,labeled_id) .^ 2)) );
        rangeG = 1;
        if labeled_per_class > 1
            accuracies = zeros( length( labeled_per_class ), length( rangeC ) * length( rangeG ) );
            for i = 1 : labeled_per_class
                id_val_test = labeled_id(i:labeled_per_class:end);                    
                X_val_test = X(:,id_val_test);
                id_val_train = unique(setdiff(labeled_id,id_val_test));
                X_val_train = X(:,id_val_train);
                [ Y_predict accuracies(i,:) ] = svm( X_val_train, X_val_test, Y(id_val_train), Y(id_val_test), 1, rangeC, rangeG );
            end
            [ bestvalaccuracy bestCG ] = max( mean( accuracies ) );
            %bestCG = find( mean( accuracies ) == bestvalaccuracy, 1, 'last' );
            bestG = floor((bestCG-1)/length(rangeC))+1;
            bestC = mod((bestCG-1),length(rangeC))+1;
        else
            bestG = 1;
            bestC = 1;
        end                
        %fprintf( 'G = %d, C = %d\n', bestG, bestC );
        Y_predict = svm( X(:,labeled_id), X(:,unlabeled_id), Y(labeled_id), Y(unlabeled_id), 1, rangeC(bestC), rangeG(bestG) );

        %Y_predict = svmlight( X(:,labeled_id), X(:,unlabeled_id), Y(labeled_id), Y(unlabeled_id) );
        
        correct = Y_predict == Y(unlabeled_id);
        correctcnt = hist( Y_predict( correct ), 1:classnum );
        accuracy_svm_norm = 0; %mean( correctcnt ./ totalcnt ) * 100;
        accuracy_svm_unnorm = sum( Y_predict == Y(unlabeled_id) ) / length( Y(unlabeled_id) ) * 100;
        Y_predict = knn( X(:,labeled_id), X(:,unlabeled_id), Y(labeled_id), 1 );
        correct = Y_predict == Y(unlabeled_id);
        correctcnt = hist( Y_predict( correct ), 1:classnum );
        accuracy_knn_norm = 0;% mean( correctcnt ./ totalcnt ) * 100;
        accuracy_knn_unnorm = sum( Y_predict == Y(unlabeled_id) ) / length( Y(unlabeled_id) ) * 100;
        %fprintf( 1, 'svm = %f/%f, knn = %f/%f\n', accuracy_svm_norm, accuracy_svm_unnorm, accuracy_knn_norm, accuracy_knn_unnorm );
        acc1 = accuracy_svm_norm;
        acc2 = accuracy_svm_unnorm;
        acc3 = accuracy_knn_norm;
        acc4 = accuracy_knn_unnorm;
    else
        %XX = X ./ repmat( sum( X, 2 ), [ 1 N ] );
        %[ Xmax idx ] = max( XX );
        min_D = Inf;
        rand( 'state', 0 );
        for i = 1 : 10
            [ idx_temp C D ] = kmeans( X', classnum ); %, 'EmptyAction', 'singleton' );
            %D = sum( D );
            if D < min_D 
                min_D = D;
                idx = idx_temp;
            end
        end
        convmat = zeros( classnum );
        for i = 1 : N
            convmat(Y(i), idx(i)) = convmat(Y(i), idx(i)) + 1;
        end
        [assignment, cost] = assignmentoptimal(max(convmat(:))-convmat);
        accuracy_clustering = (max(convmat(:))*classnum - cost) / sum(convmat(:)) * 100;
        %fprintf( 1, 'clustering = %f\n', accuracy_clustering );
        acc1 = accuracy_clustering;
        acc2 = accuracy_clustering;            
        acc3 = accuracy_clustering;
        acc4 = accuracy_clustering;            
    end
