function residual = compute_residual( U, V, X, Unonzero )

    N = size( U, 2 );
    
    VX = mex_Pw_d(U,V,X);
    residual = -mex_logL(U,VX,ones(1,N)/N);
    return;
    
    if N > 3000        
        residual = 0;
        for i = 1 : ceil( N / 1000 )
            range = (i-1)*1000+1 : min( i*1000, N );
            UU = U(:, range);
            Unonzero = UU > 0;
            VX = V * X(:,range);
            residual = residual + full( sum( sum( UU(Unonzero) .* log2( UU(Unonzero) ./ VX(Unonzero) ) ) ) );
        end        
    else
        VX = V * X;
        residual = full( sum( sum( U(Unonzero) .* log2( U(Unonzero) ./ VX(Unonzero) ) ) ) );
    end